/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#ifndef __UI_UTILS_H__
#define __UI_UTILS_H__

#include <Evas.h>
#include <efl_extension.h>
#include <stdbool.h>

#define EVENT_CLICKED                   "clicked"
#define EVENT_CHANGED                   "changed"
#define EVENT_FOCUSED                   "focused"
#define EVENT_UNFOCUSED                 "unfocused"
#define EVENT_CURSOR_CHANGED            "cursor,changed"

#define SIGNAL_PICKER_ACTION_VALUE_SET  "picker,action,value,set"

#define PART_NAVI_TITLE_RIGHT_BUTTON    "title_right_btn"
#define PART_ENTRY_GUIDE                "elm.guide"
#define PART_POPUP_TITLE                "title,text"
#define PART_TOOLBAR                    "toolbar"
#define PART_TOOLBAR_MORE_BUTTON        "toolbar_more_btn"
#define PART_ENTRY                      "elm.icon.entry"
#define PART_CONTENT                    "elm.swallow.content"
#define PART_BG                         "elm.swallow.bg"
#define PART_NAVI_ITEM_TABBAR           "tabbar"
#define PART_TEXT_MAIN                  "elm.text.main"
#define PART_TEXT                       "elm.text"
#define PART_TEXT_MULTILINE             "elm.text.multiline"

#define STYLE_POPUP                     "more/default"
#define STYLE_BUTTON_NAVIFRAME          "naviframe/title_right"
#define STYLE_TOOLBAR_TABBAR            "tabbar/item_with_title"
#define STYLE_NAVI_ITEM_TABBAR          "tabbar"

/**
 * @brief Add entry with enhanced style and clear button
 * @param[in]   parent      Parent widget
 * @param[in]   guide_text  Entry guide text
 * @param[in]   multiline   Is multiline
 * @return Entry on success, otherwise NULL
 */
Evas_Object *ui_utils_editfield_add(Evas_Object *parent, const char *guide_text, bool multiline);

/**
 * @brief Add naviframe widget
 * @param[in]   parent      Parent widget
 * @param[in]   back_cb     Hardware back button callback
 * @param[in]   cb_data     Data to pass to back_cb
 * @return Naviframe on success, otherwise NULL
 */
Evas_Object *ui_utils_navi_add(Evas_Object *parent, Eext_Event_Cb back_cb, void *cb_data);

/**
 * @brief Add layout widget
 * @param[in]   parent      Parent widget
 * @param[in]   destroy_cb  Layout destroy callback
 * @param[in]   cb_data     Data to pass to destroy_cb
 * @return Layout on success, otherwise NULL
 */
Evas_Object *ui_utils_layout_add(Evas_Object *parent, Evas_Object_Event_Cb destroy_cb, void *cb_data);

/**
 * @brief Add toolbar widget
 * @param[in]   parent      Parent widget
 * @return Toolbar on success, otherwise NULL
 */
Evas_Object *ui_utils_toolbar_add(Evas_Object *parent);

/**
 * @brief Add button to popup
 * @remarks Added button automatically hides popup when clicked so you don't
 *          need to hide it in your callback and create callbacks for cancel buttons.
 * @param[in]   popup   Popup widget
 * @param[in]   text    Button text
 * @param[in]   func    Button click callback
 * @param[in]   data    Data to pass to func
 * @return true button on success, otherwise NULL
 */
Evas_Object * ui_utils_popup_button_add(Evas_Object *popup, const char *text,
        Evas_Smart_Cb func, void *data);

/**
 * @brief Create and show popup
 * @param[in]   parent      Parent widget
 * @param[in]   title       Popup title
 * @param[in]   cancel_btn  Cancel button text
 * @return Popup on success, otherwise NULL
 */
Evas_Object *ui_utils_popup_add(Evas_Object *parent, const char *title, const char *cancel_btn);

#endif /* __UI_UTILS_H__ */
