/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __VIEW_COMMON_H__
#define __VIEW_COMMON_H__

#include <Evas.h>

#define STYLE_ITEM_DETAILS              "multiline"
#define STYLE_ITEM_CHECKBOX             "1line"

#define NAVI_ITEM_PERSON_LIST           "person_list_item"
#define NAVI_ITEM_CATEGORIES_LIST       "categories_list_item"

extern const char *_caption_create;
extern const char *_caption_save;
extern const char *_caption_cancel;
extern const char *_caption_ok;

typedef enum {
	VI_PERSON_LIST,
	VI_CATEGORIES_LIST,
	VI_MAX
} sc_view_common_view_item;

/**
 * @brief Returns to certain view
 * @param[in]   obj         Evas object wherein stored information to what view return
 * @param[in]   view_item   Navi item view to return
 */
void sc_view_common_return_to_view(Evas_Object *obj, sc_view_common_view_item view_item);

#endif //__VIEW_COMMON_H__
