/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "model/group-edit-member.h"

#include "model/contacts-utils/contacts-db-utils.h"
#include "model/contacts-utils/contacts-list-utils.h"
#include "utils/logger.h"

#include <contacts.h>
#include <Elementary.h>


contacts_list_h sc_gedit_member_add_contact_list_get(int group_id)
{
	contacts_list_h contact_list = NULL;
	sc_db_utils_is_success(contacts_db_get_all_records(_contacts_contact._uri, 0, 0, &contact_list));

	contacts_list_h members = sc_list_utils_get_records_list_int_filter(_contacts_group_relation._uri,
			_contacts_group_relation.group_id, group_id);

	contacts_record_h record = NULL;
	sc_db_utils_is_success(contacts_list_first(members));
	CONTACTS_LIST_FOREACH(members, record) {
		int contact_id = 0;
		sc_db_utils_is_success(contacts_record_get_int(record, _contacts_group_relation.contact_id, &contact_id));
		if (contact_id > 0) {
			contacts_record_h contact_record = NULL;
			sc_db_utils_is_success(contacts_list_first(contact_list));
			CONTACTS_LIST_FOREACH(contact_list, contact_record) {
				int id = 0;
				sc_db_utils_is_success(contacts_record_get_int(contact_record, _contacts_contact.id, &id));
				if (contact_id == id) {
					INF("contact_id = id = %d", id);
					sc_db_utils_is_success(contacts_list_remove(contact_list, contact_record));
					sc_db_utils_is_success(contacts_record_destroy(contact_record, true));
					break;
				}
			}
		}
	}
	sc_db_utils_is_success(contacts_list_destroy(members, true));
	sc_db_utils_is_success(contacts_list_first(contact_list));
	return contact_list;
}

contacts_list_h sc_gedit_member_remove_contact_list_get(int group_id)
{
	contacts_list_h contact_list = NULL;
	sc_db_utils_is_success(contacts_list_create(&contact_list));
	RETVM_IF(!contact_list, NULL, "contact_list is null");

	contacts_list_h members = sc_list_utils_get_records_list_int_filter(_contacts_group_relation._uri,
			_contacts_group_relation.group_id, group_id);

	contacts_record_h record = NULL;
	CONTACTS_LIST_FOREACH(members, record) {
		int contact_id = 0;
		sc_db_utils_is_success(contacts_record_get_int(record, _contacts_group_relation.contact_id, &contact_id));
		if (contact_id > 0) {
			sc_db_utils_is_success(contacts_db_get_record(_contacts_contact._uri, contact_id, &record));
			if (record) {
				sc_db_utils_is_success(contacts_list_add(contact_list, record));
			}
		}
	}
	sc_db_utils_is_success(contacts_list_destroy(members, true));
	return contact_list;
}

Eina_List *sc_gedit_member_check_data_list_get(int group_id, contacts_list_h list)
{
	RETVM_IF(!list, NULL, "list is null");
	Eina_List *result_list = NULL;
	contacts_record_h record = NULL;
	CONTACTS_LIST_FOREACH(list, record) {
		int contact_id = 0;
		sc_db_utils_is_success(contacts_record_get_int(record, _contacts_contact.id, &contact_id));
		if (contact_id > 0) {
			group_edit_member_check_data *check_data = calloc(1, sizeof(group_edit_member_check_data));
			if (check_data) {
				check_data->contact_id = contact_id;
				check_data->is_checked = false;

				char *name = NULL;
				sc_db_utils_is_success(contacts_record_get_str_p(record, _contacts_contact.display_name, &name));
				if (name) {
					check_data->name = strdup(name);
				}
				result_list = eina_list_append(result_list, check_data);
			}
		}
	}
	return result_list;
}
