/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "view/view-common.h"

#include "utils/logger.h"

#include <Elementary.h>

const char *_caption_create  = "Create";
const char *_caption_save    = "Save";
const char *_caption_cancel  = "Cancel";
const char *_caption_ok      = "OK";

void sc_view_common_return_to_view(Evas_Object *obj, sc_view_common_view_item view_item)
{
	RETM_IF(!obj, "navi is NULL");
	RETM_IF(view_item < VI_PERSON_LIST || view_item >= VI_MAX, "wrong item key")

	const char *item_str_key = NULL;
	switch (view_item) {
		case VI_PERSON_LIST:
		{
			item_str_key = NAVI_ITEM_PERSON_LIST;
			break;
		}
		case VI_CATEGORIES_LIST:
		{
			item_str_key = NAVI_ITEM_CATEGORIES_LIST;
			break;
		}
		case VI_MAX: /* Max value is not used */
			break;
		default:
			break;
	}
	Elm_Object_Item *navi_item = evas_object_data_get(obj, item_str_key);
	RETM_IF(!navi_item, "navi item is not retrieved");
	elm_naviframe_item_pop_to(navi_item);
}
