/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#define LOG_TAG "ecore_job"
#include "main.h"

static Ecore_Job *job1, *job2, *job3;

static void
_job_print_cb(void *data)
{
	char *str = data;
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s\n", str);
}

static Eina_Bool
_naviframe_pop_cb(void *data EINA_UNUSED, Elm_Object_Item *it EINA_UNUSED)
{
	return EINA_TRUE;
}

void
ecore_job_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Label*/
	Evas_Object *label = elm_label_add(ad->layout);
	elm_object_text_set(label, "Ecore Job");
	evas_object_size_hint_weight_set(label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(ad->layout, "elm.swallow.content", label);
	evas_object_show(label);

	/* job */
	char *str1 = "Job 1 started.";
	char *str2 = "Job 2 started.";
	char *str3 = "Job 3 started.";

	job1 = ecore_job_add(_job_print_cb, str1);
	job2 = ecore_job_add(_job_print_cb, str2);
	job3 = ecore_job_add(_job_print_cb, str3);

	dlog_print(DLOG_DEBUG, LOG_TAG, "Created jobs 1, 2, 3.\n");

	if (job2) {
		char *str;
		str = ecore_job_del(job2);
		job2 = NULL;
		dlog_print(DLOG_DEBUG, LOG_TAG, "Deleted job 2. Its data was: \"%s\"\n", str);
	}

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, _naviframe_pop_cb, ad);
}
