/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

typedef struct user_data {
	Evas_Object *obj;
	int *pixel;
} user_data;

static void
thread_run_cb(void *data, Ecore_Thread *thread)
{
	user_data *ud = data;

	// this mandel calc is run in the worker threads so it's here. it is
	// just here to calculate something and consume cpu to demonstrate the
	// ecore thread worker queue. don't pay much attention to the below code
	double x, xx, y, cx, cy, cox, coy;
	int iteration, hx, hy, val, r, g, b, rr, gg, bb;
	int itermax = 10000;
	double magnify = 0.02;
	int w, h;

	evas_object_image_size_get(ud->obj, &w, &h);

	magnify += ((double)(rand() % 100) / 100.0) / 4.0;
	cox = (double)(rand() % 100) / 100.0;
	coy = (double)(rand() % 100) / 100.0;
	cox /= (magnify * 3.0);
	r = rand() % 255; g = rand() % 255; b = rand() % 255;
	for (hy = 0; hy < h; hy++) {
	    for (hx = 0; hx < w; hx++) {
	    
			cx = (((float)hx) / ((float)w) - 0.5) / (magnify * 3.0);
            cy = (((float)hy) / ((float)h) - 0.5) / (magnify * 3.0);
            cx += cox;
            cy += coy;
            x = 0.0;
            y = 0.0;

            for (iteration = 1; iteration < itermax; iteration++) {
		    
				xx = (x * x) - (y * y) + cx;
				y = (2.0 * x * y) + cy;
				x = xx;
				
				if (((x * x) + (y * y)) > 100.0) iteration = 999999;
			}
			
			val = (((x * x) + (y * y)) * 2.55) / 100.0;
			
			if (val > 255) val = 255;
			if (iteration >= 99999) {
					
					rr = (r * val) / 255;
					gg = (g * val) / 255;
					bb = (b * val) / 255;
					ud->pixel[(hy * w) + hx] = (val  << 24) | (rr << 16) | (gg << 8) | (bb);

			} else
				ud->pixel[(hy * w) + hx] = 0xffffffff;
		}
	}
}

static void
thread_end_cb(void *data, Ecore_Thread *thread)
{
	user_data *ud = data;
	Evas_Coord w, h;

	//Update Image Data. Since thread_end_cb() is called from main loop thread,
	//we can access EAPI without considering any synchronization.
	evas_object_image_size_get(ud->obj, &w, &h);
	evas_object_image_data_copy_set(ud->obj, ud->pixel);
	evas_object_image_data_update_add(ud->obj, 0, 0, w, h);

	free(ud->pixel);
	free(ud);
}

static void
thread_cancel_cb(void *data, Ecore_Thread *thread)
{
	user_data *ud = data;

	free(ud->pixel);
	free(ud);
}

static void
mouse_down_cb(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
	user_data *ud = calloc(1, sizeof(user_data));
	ud->obj = obj;
	ud->pixel = malloc(256 * 256 * sizeof(int));

	//Run a thread
	ecore_thread_run(thread_run_cb, thread_end_cb, thread_cancel_cb, ud);
}

void
ecore_thread_run_exam(Evas_Object *layout)
{
	Evas_Object *img, *label, *box;

	//Create a Box
	box = elm_box_add(layout);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(box);
	elm_object_part_content_set(layout, "elm.swallow.content", box);

	//Create a Label
	label = elm_label_add(layout);
	elm_object_text_set(label, "Click area below to see changes.");
	evas_object_size_hint_align_set(label, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(label);
	elm_box_pack_end(box, label);

	//Create an Image
	img = evas_object_image_filled_add(evas_object_evas_get(layout));
	evas_object_event_callback_add(img, EVAS_CALLBACK_MOUSE_DOWN, mouse_down_cb, NULL);
	evas_object_color_set(img, 255, 255, 255, 255);
	evas_object_image_size_set(img, 256, 256);
	evas_object_size_hint_weight_set(img, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(img, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(img);
	elm_box_pack_end(box, img);
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	return EINA_TRUE;
}

void
ecore_thread_5_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Ecore Thread 5 */
	ecore_thread_run_exam(ad->layout);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
