/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

#define EDC_LAYOUTSIGNAL
#include "edc_common.h"

static void
receive_clicked_cb(void *data, Evas_Object *obj, const char *emission, const char *source)
{
	/* Edje sent signal to c */
	Evas_Object *btn = data;

	elm_object_disabled_set(btn, EINA_FALSE);
	elm_object_text_set(btn, "Send Signal");
}

static void
send_clicked_cb(void *data, Evas_Object *obj, void *event)
{
	/* Button clicked event occur */
	appdata_s *ad = data;

	elm_object_text_set(obj, "Disabled");
	elm_object_disabled_set(obj, EINA_TRUE);

	/* Send a signal to edje */
	elm_object_signal_emit(ad->layout, "elm,state,text,show", "elm");
}
static void
create_content(appdata_s *ad)
{
	Evas_Object *btn;

	btn = elm_button_add(ad->layout);
	elm_object_text_set(btn, "Send Signal");
	evas_object_show(btn);

	/* Callback add for clicked event on button object */
	evas_object_smart_callback_add(btn, "clicked", send_clicked_cb, ad);
	/* Callback add for got signal from edje */
	elm_object_signal_callback_add(ad->layout, "text,change", "LayoutSignal", receive_clicked_cb, btn);

	elm_object_part_content_set(ad->layout, "center_button" ,btn);
	elm_object_part_text_set(ad->layout, "text", "send a signal from C to edje");
}

static void
app_get_resource(const char *edj_file_in, char *edj_path_out, int edj_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(edj_path_out, edj_path_max, "%s%s", res_path, edj_file_in);
		free(res_path);
	}
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	return EINA_TRUE;
}

void
edc_layoutsignal_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;
	char edj_path[PATH_MAX] = {0, };

	/* Base Layout */
	app_get_resource(EDJ_FILE, edj_path, (int)PATH_MAX);

	ad->layout = elm_layout_add(ad->win);
	elm_layout_file_set(ad->layout, edj_path, GRP_MAIN);
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	create_content(ad);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
