/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#define LOG_TAG "eina_list"
#include "main.h"

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	return EINA_TRUE;
}

void
eina_list_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Label*/
	Evas_Object *label = elm_label_add(ad->layout);
	elm_object_text_set(label, "Eina List");
	evas_object_size_hint_weight_set(label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(ad->layout, "elm.swallow.content", label);
	evas_object_show(label);

    /* List */
	Eina_List *list = NULL;
	Eina_List *l;	// A list that is used as an iterator and points to the current node
	void *list_data;

	// Append the given data to the given linked list
	list = eina_list_append(list, "tigh");
	list = eina_list_append(list, "adar");
	list = eina_list_append(list, "baltar");
	list = eina_list_append(list, "roslin");

	EINA_LIST_FOREACH(list, l, list_data)
		dlog_print(DLOG_INFO, LOG_TAG, "%s", (char*)list_data);
	dlog_print(DLOG_INFO, LOG_TAG, "----------");

	l = eina_list_nth_list(list, 1);	// Get the nth member's list node in a list
	list = eina_list_append_relative_list(list, "cain", l);
	list = eina_list_append_relative(list, "zarek", "cain");
	list = eina_list_prepend(list, "adama");
	list = eina_list_prepend_relative(list, "gaeta", "cain");
	list = eina_list_prepend_relative_list(list, "lampkin", l);

	EINA_LIST_FOREACH(list, l, list_data)
		dlog_print(DLOG_INFO, LOG_TAG, "%s", (char*)list_data);

	eina_list_free(list);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
