/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#define LOG_TAG "evas_event"
#include "main.h"

static Evas_Object *rect;

static void
_render_flush_cb(void *data, // evas event EVAS_CALLBACK_RENDER_FLUSH_PRE callback function.
                     Evas *e,
                     void *event_info)
{
   dlog_print(DLOG_DEBUG, LOG_TAG, "Canvas is about to flush its rendering pipeline!");
}

static void
_on_mousedown(void *data, // evas object event EVAS_CALLBACK_MOUSE_DOWN callback function.
                 Evas *evas,
                 Evas_Object *o,
                 void *event_info)
{
   dlog_print(DLOG_DEBUG, LOG_TAG, "We've got mouse_down");
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	evas_object_event_callback_del(rect, EVAS_CALLBACK_MOUSE_DOWN, _on_mousedown);
	evas_object_del(rect);

	return EINA_TRUE;
}

void
evas_event_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Label*/
	Evas_Object *label = elm_label_add(ad->layout);
	elm_object_text_set(label, "Evas Event");
	evas_object_size_hint_weight_set(label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(ad->layout, "elm.swallow.content", label);
	evas_object_show(label);

	Evas *evas = evas_object_evas_get(ad->layout);

	// Adds a callback function to a given canvas event.
	evas_event_callback_add(evas, EVAS_CALLBACK_RENDER_FLUSH_PRE, _render_flush_cb, NULL);

	rect = evas_object_rectangle_add(evas);
	evas_object_color_set(rect, 0, 255, 0, 255);
	evas_object_move(rect, 100, 100);
	evas_object_resize(rect, 200, 200);
	evas_object_show(rect);

	// Add a callback function to a given Evas object event.
	evas_object_event_callback_add(rect, EVAS_CALLBACK_MOUSE_DOWN, _on_mousedown, NULL);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
