/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	return EINA_TRUE;
}

void
evas_map_mapping_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* map */
	Evas_Object *btn;
	Evas_Map *map;

	//Create a Button
	btn = elm_button_add(ad->layout);
	elm_object_text_set(btn, "Evas Map");
	evas_object_move(btn, 100, 150);
	evas_object_resize(btn, ELM_SCALE_SIZE(250), ELM_SCALE_SIZE(100));
	evas_object_show(btn);

	//Create a Evas Map
	map = evas_map_new(4);

	//Set Map Coordinates
	evas_map_point_coord_set(map, 0, 150, 100, 0);
	evas_map_point_coord_set(map, 1, 350, 100, 0);
	evas_map_point_coord_set(map, 2, 300, 200, 0);
	evas_map_point_coord_set(map, 3, 100, 400, 0);

	//Set Image UV
	evas_map_point_image_uv_set(map, 0, 0, 0);
	evas_map_point_image_uv_set(map, 1, 250, 0);
	evas_map_point_image_uv_set(map, 2, 250, 100);
	evas_map_point_image_uv_set(map, 3, 0, 100);

	//Apply map to button object
	evas_object_map_set(btn, map);

	//Free Map resource
	evas_map_free(map);

	//Enable Map Feature
	evas_object_map_enable_set(btn, EINA_TRUE);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
