/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static Ecore_Animator *anim;

Eina_Bool
evas_map_rotation_exam_animator_cb(void *data)
{
	static int i = 0;
	Evas_Map *map;
	Evas_Object *btn = data;
	Evas_Coord x, y, w, h;

	i++;
	if (i > 360) i = 0;

	evas_object_geometry_get(btn, &x, &y, &w, &h);

	//Create an Evas Map
	map = evas_map_new(4);
	evas_map_util_points_populate_from_object_full(map, btn, 0);
	evas_map_util_3d_rotate(map, i, 0, 0, x + (w / 2), y + (h / 2), 0);
	evas_map_util_3d_perspective(map,  x + (w / 2), y + (h / 2), 0, 300);

	//Apply map to button object
	evas_object_map_set(btn, map);

	//Free Map resource
	evas_map_free(map);

	//Enable Map Feature
	evas_object_map_enable_set(btn, EINA_TRUE);

	return ECORE_CALLBACK_RENEW;
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	ecore_animator_del(anim);

	return EINA_TRUE;
}

void
evas_map_rotation_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	//Create a Button
	Evas_Object *btn = elm_button_add(ad->layout);
	elm_object_text_set(btn, "Evas Map Rotation");
	evas_object_move(btn, 100, 100);
	evas_object_resize(btn, 300, 300);
	evas_object_show(btn);

	anim = ecore_animator_add(evas_map_rotation_exam_animator_cb, btn);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
