/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

struct anim_data {
    Evas_Object *btn;
    Evas_Object *img1;
    Evas_Object *img2;
    Ecore_Animator *anim;
};

static struct anim_data *anim_d;

Eina_Bool
proxy_exam_animator_cb(void *data)
{
    static int i = 0;
    Evas_Map *map1;
    Evas_Map *map2;
    anim_d = data;
    Evas_Coord x, y, w, h;

    i++;
    if (i>360) i = 0;

    // creates a Evas Map for top one.
    map1 = evas_map_new(4);  // creates a map consisted of 4 points
    evas_map_util_points_populate_from_object_full(map1, anim_d->img1, 0);  // sets the object image UV values to map
    evas_object_geometry_get(anim_d->img1, &x, &y, &w, &h);  // gets the geometry information from the object
    evas_map_util_3d_rotate(map1, 0, i, 0, x + (w / 2), y + (h / 2), 0);  // rotates by
    evas_map_util_3d_perspective(map1, x + (w / 2), y + h, 0, 1000);

    // creates a Evas Map for reflected one.
    map2 = evas_map_new(4);
    evas_map_util_points_populate_from_object(map2, anim_d->img2);
    evas_object_geometry_get(anim_d->img2, &x, &y, &w, &h);

    // image UV sets
    evas_map_point_image_uv_set(map2, 0, 0, h);
    evas_map_point_image_uv_set(map2, 1, w, h);
    evas_map_point_image_uv_set(map2, 2, w, 0);
    evas_map_point_image_uv_set(map2, 3, 0, 0);

    // color sets
    evas_map_point_color_set(map2, 0, 255, 255, 255, 255);
    evas_map_point_color_set(map2, 1, 255, 255, 255, 255);
    evas_map_point_color_set(map2, 2, 0, 0, 0, 0);
    evas_map_point_color_set(map2, 3, 0, 0, 0, 0);

    evas_map_util_3d_rotate(map2, 0, i, 0, x + (w / 2), y + (h / 2), 0);
    evas_map_util_3d_perspective(map2, x + (w / 2), y, 0, 1000);

    // applys map to proxy objects
    evas_object_map_set(anim_d->img1, map1);
    evas_object_map_set(anim_d->img2, map2);

    // frees map resources
    evas_map_free(map1);
    evas_map_free(map2);

    // enable map features
    evas_object_map_enable_set(anim_d->img1, EINA_TRUE);
    evas_object_map_enable_set(anim_d->img2, EINA_TRUE);

    return ECORE_CALLBACK_RENEW;
}

void
proxy_exam(Evas_Object *layout)
{
    anim_d = calloc(1, sizeof(struct anim_data));

    // creates a button
    anim_d->btn = elm_button_add(layout);
    elm_object_text_set(anim_d->btn, "Proxy Object Test");
    evas_object_move(anim_d->btn, 100, 100);
    evas_object_resize(anim_d->btn, ELM_SCALE_SIZE(300), ELM_SCALE_SIZE(200));
    evas_object_show(anim_d->btn);

    // creates a proxy1
    Evas *e = evas_object_evas_get(layout);
    anim_d->img1 = evas_object_image_filled_add(e);
    evas_object_image_source_set(anim_d->img1, anim_d->btn);
    evas_object_image_source_visible_set(anim_d->img1, EINA_FALSE);
    evas_object_move(anim_d->img1, 100, 100);
    evas_object_resize(anim_d->img1, ELM_SCALE_SIZE(300), ELM_SCALE_SIZE(200));
    evas_object_show(anim_d->img1);

    // creates a proxy2
    anim_d->img2 = evas_object_image_filled_add(e);
    evas_object_image_source_set(anim_d->img2, anim_d->btn);
    evas_object_move(anim_d->img2, 100, 300);
    evas_object_resize(anim_d->img2, ELM_SCALE_SIZE(300), ELM_SCALE_SIZE(200));
    evas_object_show(anim_d->img2);

    anim_d->anim = ecore_animator_add(proxy_exam_animator_cb, anim_d);
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	evas_object_del(anim_d->img1);
	evas_object_del(anim_d->img2);
	ecore_animator_del(anim_d->anim);

	return EINA_TRUE;
}

void
evas_proxy_object_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Label*/
	Evas_Object *label = elm_label_add(ad->layout);
	elm_object_text_set(label, "Proxy Object");
	evas_object_size_hint_weight_set(label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(ad->layout, "elm.swallow.content", label);
	evas_object_show(label);

	/*
	 * Proxy Object Sample
	 */
	proxy_exam(ad->layout);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
