/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static Evas_Object *bg;

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	evas_object_del(bg);

	return EINA_TRUE;
}

void
evas_rectangle_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Rectangle */
	Evas *evas = evas_object_evas_get(ad->win);

	// Add a rectangle to the given evas.
	bg = evas_object_rectangle_add(evas);

	// Set the general/main color of the given Evas object to the given one.
	evas_object_color_set(bg, 255, 0, 0, 255);

	// Move the given Evas object to the given location inside its canvas’ viewport.
	evas_object_move(bg, 50, 50);

	// Change the size of the given Evas object.
	evas_object_resize(bg, 200, 200);

	// Make the given Evas object visible.
	evas_object_show(bg);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
