#ifndef __model_H__
#define __model_H__

#include <app_event.h>
#include <bundle.h>
#include <stdbool.h>

#define CUSTOM_EVENT_KEY_STATUS "custom_event_status"

typedef enum { ET_BATTERY_CHARGER_STATUS, ET_BATTERY_LEVEL_STATUS, ET_USB_STATUS, ET_EARJACK_STATUS, ET_DISPLAY_STATE,
				ET_BOOT_COMPLETED, ET_SYSTEM_SHUTDOWN, ET_LOW_MEMORY, ET_WIFI_STATE, ET_BT_STATE,
				ET_LOCATION_ENABLE_STATE, ET_GPS_ENABLE_STATE, ET_NPS_ENABLE_STATE, ET_INCOMMING_MSG, ET_TIME_CHANGED,
				ET_TIME_ZONE, ET_HOUR_FORMAT, ET_LANGUAGE_SET, ET_REGION_FORMAT, ET_SILENT_MODE,
				ET_VIBRATION_STATE, ET_SCREEN_AUTOROTATE_STATE, ET_MOBILE_DATA_STATE, ET_DATA_ROAMING_STATE, ET_FONT_SET } event_type_t;

struct __system_ev_info {
	event_type_t type;
	char *name;
	char *desc;
	char *status_1;
	char *status_2;
	char *status_3;
	event_handler_h event_h;
};

typedef struct __system_ev_info system_ev_info_s;
typedef struct __system_ev_info custom_ev_info_s;

extern void model_finit(void);
extern int model_get_system_events_count(void);
extern bool model_get_system_event_info(int index, system_ev_info_s **ev_info);
extern bool model_add_system_event_handler(system_ev_info_s *ev_info, event_cb callback, void *user_data);
extern bool model_add_custom_event_handler(custom_ev_info_s *ev_info, event_cb callback, void *user_data);
extern bool model_create_custom_event_info(const char *event_name, custom_ev_info_s **ev_info);
extern bool model_publish_event(const char *event_name);
extern bool model_assign_event_status(char **ev_status, const char *new_status);
extern bool model_check_event_exists(const char *event_name, bool *exists);
extern bool model_get_bundle_str(bundle *bundle_obj, const char *key, char **str);

#endif /* __model_H__ */