#ifndef __view_H__
#define __view_H__

#include <Evas.h>
#include <Elementary.h>

typedef void (* event_do_publish_cb)(const char *event_name);
typedef bool (* event_get_system_info_cb)(int index, void **ev_info);
typedef bool (* event_set_custom_info_cb)(const char *event_name, void **ev_info);

struct __viewcallbacks {
	event_do_publish_cb do_publish_cb;
	event_get_system_info_cb get_system_info_cb;
	event_set_custom_info_cb set_custom_info_cb;
};

typedef struct __viewcallbacks viewcallbacks_s;

struct __viewdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *layout_main_panel;
	Evas_Object *main_toolbar;
	Evas_Object *main_toolbar_item_system_ev;
	Evas_Object *main_toolbar_item_custom_ev;
	Evas_Object *layout_system_ev;
	Evas_Object *system_ev_list;
	Evas_Object *layout_custom_ev;
	Evas_Object *custom_ev_name;
	Evas_Object *custom_ev_submit;
	Evas_Object *custom_ev_list;
	Elm_Genlist_Item_Class *custom_ev_itc;
	viewcallbacks_s callbacks;
};

typedef struct __viewdata viewdata_s;

extern bool view_create_base_gui(viewdata_s *vd);
extern void view_destroy_base_gui(viewdata_s *vd);
extern void view_update_system_events(void);
extern void view_update_custom_events(void);
extern void view_display_custom_event(const char *event_name, const char *event_status);

#endif /* __view_H__ */