#include "$(appName).h"
#include "controller.h"
#include "view/view.h"

struct __appdata {
	viewdata_s view;
};

typedef struct __appdata appdata_s;

static bool __create_app(void *data)
{
	appdata_s *ad = (appdata_s *)data;

	return controller_init(&ad->view);
}

static void __control_app(app_control_h app_control, void *data)
{
}

static void __pause_app(void *data)
{
}

static void __resume_app(void *data)
{
}

static void __terminate_app(void *data)
{
	appdata_s *ad = (appdata_s *)data;

	controller_finit(&ad->view);
}

static void __ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void __ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
}

static void __ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
}

static void __ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
}

static void __ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
}

int main(int argc, char *argv[])
{
	appdata_s ad = {{0,},};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback;
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = __create_app;
	event_callback.terminate = __terminate_app;
	event_callback.pause = __pause_app;
	event_callback.resume = __resume_app;
	event_callback.app_control = __control_app;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, __ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, __ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, __ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, __ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, __ui_app_region_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE)
		controller_log(DLOG_ERROR, "Function ui_app_main() failed with error = %d", ret);

	return ret;
}
