#include <Eina.h>
#include "$(appName).h"
#include "view/defines.h"
#include "view/generic.h"
#include "view/view.h"
#include "controller.h"

#define __MSG_BUFF 256

static viewdata_s *__viewdata = NULL;

static void __view_custom_event_toast_timeout_cb(void *data, Evas_Object *obj, void *event_info)
{
	evas_object_del(obj);
}

static void __view_delete_win_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static void __view_layout_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	viewdata_s *vd = (viewdata_s *)data;

	elm_win_lower(vd->win);
}

static void __view_toolbar_item_selected_cb(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *current_page = elm_object_part_content_unset(__viewdata->layout_main_panel, PART_MAIN_CONTENT);
	if (current_page)
		evas_object_hide(current_page);

	if (!data)
		return;

	elm_object_part_content_set(__viewdata->layout_main_panel, PART_MAIN_CONTENT, (Evas_Object *)data);
}

static bool __view_get_custom_event_name(viewdata_s *vd, char **ev_name)
{
	*ev_name = NULL;

	const char *entry = elm_entry_entry_get(vd->custom_ev_name);
	if (!entry || strlen(entry) == 0)
		return false;

	*ev_name = strdup(entry);

	return true;
}

static void __view_custom_event_item_select_cb(void *data, Evas_Object *obj, void *event_info)
{
	custom_ev_info_s *ev_info = (custom_ev_info_s *)data;

	if (!ev_info) {
		controller_log(DLOG_ERROR, "ev_info == NULL !!!");
		return;
	} else if (!ev_info->name) {
		controller_log(DLOG_ERROR, "ev_info->name == NULL !!!");
		return;
	}

	if (__viewdata->callbacks.do_publish_cb)
		__viewdata->callbacks.do_publish_cb(ev_info->name);
}

static void __view_register_event_button_clicked_cb(void *data, Evas_Object *obj, void *event_info)
{
	viewdata_s *vd = (viewdata_s *)data;
	custom_ev_info_s *ev_info = NULL;
	char *event_name = NULL;

	if (!__view_get_custom_event_name(vd, &event_name)) {
		controller_log(DLOG_WARN, "The custom event has no name assigned.");
		return;
	}

	bool ret = false;
	if (vd->callbacks.set_custom_info_cb)
		ret = vd->callbacks.set_custom_info_cb((const char *)event_name, (void *)&ev_info);

	free(event_name);

	if (!ret)
		return;

	elm_genlist_item_append(__viewdata->custom_ev_list,
							__viewdata->custom_ev_itc,
							(void *)ev_info,
							NULL,
							ELM_GENLIST_ITEM_NONE,
							__view_custom_event_item_select_cb,
							(void *)ev_info);
}

static char *__view_get_system_ev_item_label_cb(void *data, Evas_Object *obj, const char *part)
{
	system_ev_info_s *ev_info = (system_ev_info_s *)data;

	if (!ev_info) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return NULL;
	}

	if (!strcmp(part, "elm.text")) {
		return strdup(ev_info->desc);
	} else if (!strcmp(part, "elm.text.sub")) {
		char message[__MSG_BUFF] = {0,};
		if (ev_info->status_1)
			strncat(message, ev_info->status_1, strlen(ev_info->status_1));

		if (ev_info->status_2)
			strncat(message, ev_info->status_2, strlen(ev_info->status_2));

		if (ev_info->status_3)
			strncat(message, ev_info->status_3, strlen(ev_info->status_3));

		if (strlen(message) == 0)
			strncat(message, "---", 3);

		return strdup(message);
	}

	return NULL;
}

static char *__view_get_custom_ev_item_label_cb(void *data, Evas_Object *obj, const char *part)
{
	custom_ev_info_s *ev_info = (custom_ev_info_s *)data;

	if (!ev_info) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return NULL;
	}

	if (!strcmp(part, "elm.text")) {
		return strdup(ev_info->name);
	} else if (!strcmp(part, "elm.text.sub")) {
		if (ev_info->status_1)
			return strdup(ev_info->status_1);

		return strdup("---");
	}

	return NULL;
}

static void __view_del_system_ev_item_cb(void *data, Evas_Object *obj)
{
	/* Nothing to free. */
}

static void __view_del_custom_ev_item_cb(void *data, Evas_Object *obj)
{
	/* Nothing to free. */
}

static bool __view_create_main_panel(viewdata_s *vd)
{
	vd->win = view_generic_create_window(__view_delete_win_request_cb);
	if (!vd->win)
		return false;

	vd->conform = view_generic_create_conformant(vd->win);
	if (!vd->conform)
		return false;

	vd->layout_main_panel = view_generic_create_set_layout(vd->conform, EDJ_MAIN_FILE_NAME, GROUP_MAIN, NULL);
	if (!vd->layout_main_panel)
		return false;

	eext_object_event_callback_add(vd->layout_main_panel, EEXT_CALLBACK_BACK, __view_layout_back_cb, (void *)vd);

	vd->main_toolbar = view_generic_create_toolbar(vd->layout_main_panel, PART_MAIN_TOOLBAR);
	if (!vd->main_toolbar)
		return false;

	vd->main_toolbar_item_system_ev = elm_toolbar_item_append(vd->main_toolbar, NULL, "System events", __view_toolbar_item_selected_cb, NULL);
	if (!vd->main_toolbar_item_system_ev)
		return false;

	vd->main_toolbar_item_custom_ev = elm_toolbar_item_append(vd->main_toolbar, NULL, "Custom events", __view_toolbar_item_selected_cb, NULL);
	if (!vd->main_toolbar_item_custom_ev)
		return false;

	return true;
}

static bool __view_create_system_ev_view(viewdata_s *vd)
{
	vd->layout_system_ev = view_generic_create_layout(vd->layout_main_panel, EDJ_SYSTEM_EV_FILE_NAME, GROUP_SYSTEM_EV);
	if (!vd->layout_system_ev)
		return false;

	vd->system_ev_list = view_generic_create_genlist(vd->layout_system_ev, PART_SYSTEM_EV_CONTENT);
	if (!vd->system_ev_list)
		return false;

	Elm_Genlist_Item_Class *itc = view_generic_create_genlist_item_class("double_label", __view_get_system_ev_item_label_cb, __view_del_system_ev_item_cb);
	if (!itc)
		return false;

	if (!vd->callbacks.get_system_info_cb)
		return false;

	int i = 0;
	system_ev_info_s *ev_info = NULL;
	while (vd->callbacks.get_system_info_cb(i, (void*)&ev_info)) {
		elm_genlist_item_append(vd->system_ev_list,
								itc,
								(void *)ev_info,
								NULL,
								ELM_GENLIST_ITEM_NONE,
								NULL,
								NULL);

		i++;
	}

	return true;
}

static bool __view_create_custom_ev_view(viewdata_s *vd)
{
	vd->layout_custom_ev = view_generic_create_layout(vd->layout_main_panel, EDJ_CUSTOM_EV_FILE_NAME, GROUP_CUSTOM_EV);
	if (!vd->layout_custom_ev)
		return false;

	vd->custom_ev_name = view_generic_create_entry(vd->layout_custom_ev, PART_CUSTOM_EV_EDIT_PANEL_EDIT);
	if (!vd->custom_ev_name)
		return false;

	elm_entry_scrollable_set(vd->custom_ev_name, EINA_TRUE);

	vd->custom_ev_submit = view_generic_create_button(vd->layout_custom_ev, PART_CUSTOM_EV_SUBMIT, "Register event", __view_register_event_button_clicked_cb, (void *)vd);
	if (!vd->custom_ev_submit)
		return false;

	vd->custom_ev_list = view_generic_create_genlist(vd->layout_custom_ev, PART_CUSTOM_EV_LIST);
	if (!vd->custom_ev_list)
		return false;

	vd->custom_ev_itc = view_generic_create_genlist_item_class("double_label", __view_get_custom_ev_item_label_cb, __view_del_custom_ev_item_cb);
	if (!vd->custom_ev_itc)
		return false;

	return true;
}

bool view_create_base_gui(viewdata_s *vd)
{
	__viewdata = vd;

	if (!__view_create_main_panel(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	if (!__view_create_system_ev_view(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	if (!__view_create_custom_ev_view(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	/* The layouts are assigned to the item's data field. These layouts are used in
	 * __view_toolbar_item_selected_cb() callback function to switch the layout
	 * on toolbar's item selection.
	 */
	elm_object_item_data_set(vd->main_toolbar_item_system_ev, (void *)vd->layout_system_ev);
	elm_object_item_data_set(vd->main_toolbar_item_custom_ev, (void *)vd->layout_custom_ev);

	/* The "System events" tab is marked as selected
	 * (the __view_toolbar_item_selected_cb() callback function is not
	 * automatically called).
	 */
	elm_toolbar_item_selected_set(vd->main_toolbar_item_system_ev, EINA_TRUE);

	/* Set the vd->layout_system_ev as the content of vd->layout_main_panel layout because the
	 * __view_toolbar_item_selected_cb() callback function is not called
	 * when elm_toolbar_item_selected_set() is invoked.
	 */
	elm_object_part_content_set(vd->layout_main_panel, PART_MAIN_CONTENT, vd->layout_system_ev);

	evas_object_show(vd->win);

	return true;
}

void view_destroy_base_gui(viewdata_s *vd)
{
	if (!vd)
		return;

	if (vd->win)
		evas_object_del(vd->win);
}

void view_update_system_events(void)
{
	elm_genlist_realized_items_update(__viewdata->system_ev_list);
}

void view_update_custom_events(void)
{
	elm_genlist_realized_items_update(__viewdata->custom_ev_list);
}

void view_display_custom_event(const char *event_name, const char *event_status)
{
	char toast_message[512] = {0,};
	snprintf(toast_message, sizeof(toast_message), "Custom event occured: <b>%s</b> with status: <b>%s</b>.", event_name, event_status);

	Evas_Object *toast = view_generic_create_toast(__viewdata->win, toast_message, 4.0);
	if (!toast)
		return;

	evas_object_smart_callback_add(toast, "timeout", __view_custom_event_toast_timeout_cb, NULL);
	evas_object_show(toast);
}