#include "view/main_view.h"
#include "view/top_panel.h"
#include "$(appName).h"
#include "$(appName)_utils.h"

#define BIND_FILE 				"bind.txt"
const char bind_file_content[] = "Hello world !";

static struct {
	bool autosave_on;
} s_constroller_data = {
	.autosave_on = false
};


static void
__attach_callbacks(void);

static void
__file_bind_cb(void *data, Evas_Object *obj, void *event_info);

static void
__autosave_toggle_cb(void *data, Evas_Object *obj, void *event_info);

static void
__bind_file_create(void);

bool
create_application_view(void)
{
	__bind_file_create();

	if (!create_main_view()) {
		dlog_print(DLOG_ERROR, LOG_TAG, "View creation failed: on window handle");
		destroy_main_view();
		return false;
	}

	__attach_callbacks();

	dlog_print(DLOG_DEBUG, LOG_TAG, "View creation successful");

	return true;
}

static void
__attach_callbacks(void)
{
	attach_callbacks(__autosave_toggle_cb, __file_bind_cb);
}

void
terminate_application(void)
{
	/* detach callbacks: */
	destroy_main_view();
}

static void
__file_bind_cb(void *data, Evas_Object *obj, void *event_info)
{
	char bind_file_full_path[FILE_PATH_MAX_LEN] = {0,};

	compile_data_path(BIND_FILE, bind_file_full_path);
	bind_file_to_main_view_entry(bind_file_full_path);
	set_entry_autosave(s_constroller_data.autosave_on);
}

static void
__autosave_toggle_cb(void *data, Evas_Object *obj, void *event_info)
{
	s_constroller_data.autosave_on = !s_constroller_data.autosave_on;
	set_entry_autosave(s_constroller_data.autosave_on);
}

static void
__bind_file_create(void)
{
	FILE *fp = NULL;
	char bind_file_full_path[FILE_PATH_MAX_LEN] = {0,};

	compile_data_path(BIND_FILE, bind_file_full_path);

	/* check if file does not exist: */
	if (access(bind_file_full_path, F_OK)) {
	    fp = fopen(bind_file_full_path, "w+");

	    dlog_print(DLOG_DEBUG, LOG_TAG, "File %s does not exist - creating", bind_file_full_path);

	    if (!fp) {
		    dlog_print(DLOG_DEBUG, LOG_TAG, "Could not create file");
	    	return;
	    }
	    fwrite(bind_file_content, sizeof(char), sizeof(bind_file_content), fp);
	    fclose(fp);
	}
}
