#include "$(appName).h"
#include "$(appName)_utils.h"
#include <Elementary.h>

static void __compile_path(char *(*path_function)(void), const char *res_file_name, char *full_path_out)
{
	char *res_path = path_function();
	if (res_path) {
		snprintf(full_path_out, FILE_PATH_MAX_LEN, "%s%s", res_path, res_file_name);
		free(res_path);
	}
}

void
compile_resource_path(const char *res_file_name, char *full_path_out)
{
	__compile_path(app_get_resource_path, res_file_name, full_path_out);
}

void
compile_data_path(const char *res_file_name, char *full_path_out)
{
	__compile_path(app_get_data_path, res_file_name, full_path_out);
}
