#include <dlog.h>

#include "view/main_view.h"
#include "view/top_panel.h"
#include "$(appName).h"
#include "../res/edje/edje_definitions.h"
#include "$(appName)_utils.h"


static struct {
	Evas_Object *win;
	Evas_Object *win_layout_entry_conatiner;
	Evas_Object *entry;
	Evas_Object *win_layout_top_panel;
	Evas_Smart_Cb autosave_toggle_cb;
	Evas_Smart_Cb file_bind_cb;
	int kbd_current_layout;

} s_view_data = {
	.win = NULL,
	.win_layout_entry_conatiner = NULL,
	.entry = NULL,
	.win_layout_top_panel = NULL,
	.autosave_toggle_cb = NULL,
	.file_bind_cb = NULL,
	.kbd_current_layout = 0
};

static Elm_Input_Panel_Layout available_layouts[] = {
													  ELM_INPUT_PANEL_LAYOUT_NORMAL,
													  ELM_INPUT_PANEL_LAYOUT_NUMBERONLY,
													  ELM_INPUT_PANEL_LAYOUT_PHONENUMBER,
													  ELM_INPUT_PANEL_LAYOUT_MONTH
													 };

static void
__delete_cb(void *data, Evas_Object *obj, void *event_info);

static void
_get_main_window_dimensions(Evas_Coord *w, Evas_Coord *h);

static bool
__create_entry(void);

static bool
__create_entry_container(void);

static void
__attach_callbacks(void);

static void
__keypad_layout_changed_cb(void *data, Evas_Object *obj, void *event_info);

static void
__toggle_autosave(void *data, Evas_Object *obj, void *event_info);

static void
__bind_file(void *data, Evas_Object *obj, void *event_info);

static void
__hw_back_button_cb(void *data, Evas_Object *obj, void *event_info);

bool
create_main_view(void)
{
	int screen_width = 0, screen_height = 0;
	bool entry_container_res = false;
	bool entry_res = false;

	s_view_data.win = elm_win_util_standard_add(PACKAGE, PACKAGE);

	if (!s_view_data.win) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: main window");
		return false;
	}

	elm_win_conformant_set(s_view_data.win, EINA_FALSE);
	elm_win_autodel_set(s_view_data.win, EINA_TRUE);
	elm_win_screen_size_get(s_view_data.win, NULL, NULL, &screen_width, &screen_height);
	evas_object_resize(s_view_data.win, screen_width, screen_height);

	evas_object_smart_callback_add(s_view_data.win, "delete,request", __delete_cb, NULL);
	eext_object_event_callback_add(s_view_data.win, EEXT_CALLBACK_BACK, __hw_back_button_cb, NULL);

	entry_container_res = __create_entry_container();

	if (!entry_container_res)
		return false;

	entry_res = __create_entry();

	if (!entry_res)
		return false;

	s_view_data.win_layout_top_panel = _create_top_panel(s_view_data.win);

	if (!s_view_data.win_layout_top_panel)
		return false;

	/* position top panel, and show it: */
	evas_object_resize(s_view_data.win_layout_top_panel, screen_width, screen_height);
	evas_object_move(s_view_data.win_layout_top_panel, 0, 0);
	evas_object_show(s_view_data.win_layout_top_panel);

	__attach_callbacks();

	/* Show window after base gui is set up */
	evas_object_show(s_view_data.win);

	return true;
}

void
destroy_main_view(void)
{
	s_view_data.file_bind_cb = NULL;
	s_view_data.autosave_toggle_cb = NULL;
	_detach_ui_callbacks();
	evas_object_del(s_view_data.win);
	s_view_data.win = NULL;
}

void
bind_file_to_main_view_entry(const char *file_str)
{
	if (!elm_entry_file_set(s_view_data.entry, file_str, ELM_TEXT_FORMAT_PLAIN_UTF8)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failed to bind file %s . Bad file name ?", file_str);
	}
	elm_entry_autosave_set(s_view_data.entry, EINA_TRUE);
}

void set_entry_autosave(Eina_Bool on)
{
	elm_entry_autosave_set(s_view_data.entry, on);
	dlog_print(DLOG_ERROR, LOG_TAG, "AUTOSAVE: %d",
	elm_entry_autosave_get(s_view_data.entry));
}

void
attach_callbacks(Evas_Smart_Cb autosave_toggle_cb, Evas_Smart_Cb bind_file_cb)
{
	s_view_data.autosave_toggle_cb = autosave_toggle_cb;
	s_view_data.file_bind_cb = bind_file_cb;
}

static void
__delete_cb(void *data, Evas_Object *obj, void *event_info)
{
	_detach_ui_callbacks();
	ui_app_exit();
}

static void
_get_main_window_dimensions(Evas_Coord *w, Evas_Coord *h)
{
	evas_object_geometry_get(s_view_data.win, NULL, NULL, w, h);
}

static bool
__create_entry(void)
{
	s_view_data.entry = elm_entry_add(s_view_data.win);

	if (!s_view_data.entry) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: entry widget");
		return false;
	}

	elm_object_part_content_set(s_view_data.win_layout_entry_conatiner, TEXT_INPUT_PART, s_view_data.entry);
	elm_entry_scrollable_set(s_view_data.entry, EINA_TRUE);

	return true;
}

static bool
__create_entry_container()
{
	int win_width = 0, win_height = 0;
	char layout_file_full_path[FILE_PATH_MAX_LEN] = {0,};

	_get_main_window_dimensions(&win_width, &win_height);

	s_view_data.win_layout_entry_conatiner = elm_layout_add(s_view_data.win);

	if (!s_view_data.win_layout_entry_conatiner) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: entry container");
		return false;
	}

	compile_resource_path(WIN_LAYOUT_CONTAINER_EDJ, layout_file_full_path);

	evas_object_resize(s_view_data.win_layout_entry_conatiner, win_width, win_height);
	evas_object_move(s_view_data.win_layout_entry_conatiner, 0, 0);

	if (!elm_layout_file_set(s_view_data.win_layout_entry_conatiner, layout_file_full_path, MAIN_GROUP)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Could not set layout file on entry container");
		return false;
	}

	evas_object_show(s_view_data.win_layout_entry_conatiner);

	return true;
}

static void
__attach_callbacks(void)
{
	_attach_ui_callbacks(__keypad_layout_changed_cb, (void *)LAYOUT_PREV, (void *)LAYOUT_NEXT,
										  __toggle_autosave, __bind_file);
}

static void
__keypad_layout_changed_cb(void *data, Evas_Object *obj, void *event_info)
{
	if (data == LAYOUT_PREV) {
		--s_view_data.kbd_current_layout;
	} else {
		++s_view_data.kbd_current_layout;
	}

	if (s_view_data.kbd_current_layout < 0) {
		s_view_data.kbd_current_layout = sizeof(available_layouts)/sizeof(Elm_Input_Panel_Layout) -1;
	}

	if (s_view_data.kbd_current_layout >= sizeof(available_layouts)/sizeof(Elm_Input_Panel_Layout)) {
		s_view_data.kbd_current_layout = 0;
	}

	elm_entry_input_panel_hide(s_view_data.entry);
	elm_entry_input_panel_layout_set(s_view_data.entry, available_layouts[s_view_data.kbd_current_layout]);
	elm_entry_input_panel_show(s_view_data.entry);
	elm_object_focus_allow_set(s_view_data.entry, EINA_TRUE);
	elm_object_focus_set(s_view_data.entry, EINA_TRUE);
}

static void
__toggle_autosave(void *data, Evas_Object *obj, void *event_info)
{
	dlog_print(DLOG_INFO, LOG_TAG, "Autosave toggle");

	if (s_view_data.autosave_toggle_cb) {
		s_view_data.autosave_toggle_cb(NULL, NULL, NULL);
	}
}

static void
__bind_file(void *data, Evas_Object *obj, void *event_info)
{
	dlog_print(DLOG_INFO, LOG_TAG, "Binding file");

	if (s_view_data.file_bind_cb) {
		s_view_data.file_bind_cb(NULL, NULL, NULL);
	}
}

static void
__hw_back_button_cb(void *data, Evas_Object *obj, void *event_info)
{
	elm_win_lower(s_view_data.win);
}
