#include "view/top_panel.h"
#include "../res/edje/edje_definitions.h"
#include "$(appName)_utils.h"
#include "$(appName).h"

#define FILE_SELECTOR_WIDTH 700
#define FILE_SELECTOR_HEIGHT 800

static struct {
	Evas_Object *top_panel_conatiner;
	Evas_Object *btn_layout_prev;
	Evas_Object *btn_layout_next;
	Evas_Object *check_autosave_toggle;
	Evas_Object *btn_bind_file;
	Evas_Smart_Cb keypad_change_cb;
	Evas_Smart_Cb autosave_toggle_cb;
	Evas_Smart_Cb bind_file_cb;

} s_view_data = {
	.top_panel_conatiner = NULL,
	.btn_layout_prev = NULL,
	.btn_layout_next = NULL,
	.check_autosave_toggle = NULL,
	.btn_bind_file = NULL,
	.keypad_change_cb = NULL,
	.autosave_toggle_cb = NULL,
	.bind_file_cb = NULL

};

static void
__create_button(Evas_Object **button, Evas_Object *container, const char *part_name);

static void
__create_checkbox(Evas_Object **check, Evas_Object *container, const char *part_name);

Evas_Object *
_create_top_panel(Evas_Object *parent)
{
	char layout_file_full_path[FILE_PATH_MAX_LEN] = {0,};

	if (s_view_data.top_panel_conatiner) {
		return s_view_data.top_panel_conatiner;
	}

	compile_resource_path(WIN_LAYOUT_CONTAINER_EDJ, layout_file_full_path);

	/* let's create container: */
	s_view_data.top_panel_conatiner = elm_layout_add(parent);

	if (!s_view_data.top_panel_conatiner) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: top panel container");
		evas_object_del(s_view_data.top_panel_conatiner);
		return s_view_data.top_panel_conatiner = NULL;
	}

	if (!elm_layout_file_set(s_view_data.top_panel_conatiner, layout_file_full_path, TOP_PANEL_GROUP)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Could not set layout file on top panel container");
		evas_object_del(s_view_data.top_panel_conatiner);
		return s_view_data.top_panel_conatiner = NULL;
	}

	/* ... and buttons inside it: */
	__create_button(&s_view_data.btn_layout_prev, s_view_data.top_panel_conatiner, PREV_LAYOUT_BUTTON_PART);
	if (!s_view_data.btn_layout_prev) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: previous layout button");
		evas_object_del(s_view_data.top_panel_conatiner);
		return s_view_data.top_panel_conatiner = NULL;
	}

	__create_button(&s_view_data.btn_layout_next, s_view_data.top_panel_conatiner, NEXT_LAYOUT_BUTTON_PART);
	if (!s_view_data.btn_layout_next) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: next layout button");
		evas_object_del(s_view_data.top_panel_conatiner);
		return s_view_data.top_panel_conatiner = NULL;
	}

	__create_checkbox(&s_view_data.check_autosave_toggle, s_view_data.top_panel_conatiner, AUTOSAVE_ON_OFF_BUTTON_PART);
	if (!s_view_data.check_autosave_toggle) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: save file button");
		evas_object_del(s_view_data.top_panel_conatiner);
		return s_view_data.top_panel_conatiner = NULL;
	}

	__create_button(&s_view_data.btn_bind_file, s_view_data.top_panel_conatiner, BIND_FILE_BUTTON_PART);
	if (!s_view_data.btn_bind_file) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failure allocating resource: load file button");
		evas_object_del(s_view_data.top_panel_conatiner);
		return s_view_data.top_panel_conatiner = NULL;
	}

	return s_view_data.top_panel_conatiner;
}

void
_attach_ui_callbacks(Evas_Smart_Cb keypad_layout_change_cb,
										   void *data_prev, void *data_next,
										   Evas_Smart_Cb autosave_toggle_button_cb,
										   Evas_Smart_Cb bind_file_button_cb
											)
{

	if (!s_view_data.keypad_change_cb) {
		evas_object_smart_callback_add(s_view_data.btn_layout_prev, "clicked", keypad_layout_change_cb, data_prev);
		evas_object_smart_callback_add(s_view_data.btn_layout_next, "clicked", keypad_layout_change_cb, data_next);
		s_view_data.keypad_change_cb = keypad_layout_change_cb;
	}

	if (!s_view_data.bind_file_cb) {
		evas_object_smart_callback_add(s_view_data.btn_bind_file, "clicked", bind_file_button_cb, NULL);
		s_view_data.bind_file_cb = bind_file_button_cb;
	}

	if (!s_view_data.autosave_toggle_cb) {
		evas_object_smart_callback_add(s_view_data.check_autosave_toggle, "changed", autosave_toggle_button_cb, NULL);
		elm_check_state_set(s_view_data.check_autosave_toggle, EINA_FALSE);
		s_view_data.autosave_toggle_cb = autosave_toggle_button_cb;
	}
}

void _detach_ui_callbacks(void)
{
	evas_object_smart_callback_del(s_view_data.btn_layout_prev, "clicked", s_view_data.keypad_change_cb);
	evas_object_smart_callback_del(s_view_data.btn_layout_next, "clicked", s_view_data.keypad_change_cb);
	s_view_data.keypad_change_cb = NULL;

	evas_object_smart_callback_del(s_view_data.btn_bind_file, "clicked", s_view_data.bind_file_cb);
	s_view_data.bind_file_cb = NULL;

	evas_object_smart_callback_del(s_view_data.check_autosave_toggle, "clicked", s_view_data.autosave_toggle_cb);
	s_view_data.autosave_toggle_cb = NULL;
}

static void
__create_checkbox(Evas_Object **check, Evas_Object *container, const char *part_name)
{
	*check = elm_check_add(s_view_data.top_panel_conatiner);

	if (!(*check)) {
		return;
	}

	elm_object_part_content_set(container, part_name, (*check));
}

static void
__create_button(Evas_Object **button, Evas_Object *container, const char *part_name)
{
	*button = elm_button_add(s_view_data.top_panel_conatiner);

	if (!(*button)) {
		return;
	}

	elm_object_part_content_set(container, part_name, (*button));
}
