#ifndef __generic_H__
#define __generic_H__

#include <Evas.h>
#include <Elementary.h>

extern Evas_Object *view_generic_create_window(Evas_Smart_Cb on_delete_cb);
extern Evas_Object *view_generic_create_conformant(Evas_Object *parent);
extern Evas_Object *view_generic_create_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group);
extern Evas_Object *view_generic_create_set_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group, const char *target_part_name);
extern Evas_Object *view_generic_create_box(Evas_Object *parent, const char *target_part_name);
extern Evas_Object *view_generic_create_toolbar(Evas_Object *parent, const char *target_part_name);
extern Evas_Object *view_generic_create_entry(Evas_Object *parent, const char *target_part_name);
extern Evas_Object *view_generic_create_label(Evas_Object *parent, const char *target_part_name, const char *caption);
extern Evas_Object *view_generic_create_spinner(Evas_Object *parent, const char *target_part_name);
extern Evas_Object *view_generic_create_checkbox(Evas_Object *parent, const char *target_part_name, const char *caption);
extern Evas_Object *view_generic_create_genlist(Evas_Object *parent, const char *target_part_name);
extern Evas_Object *view_generic_create_list(Evas_Object *parent, const char *target_part_name);
extern Elm_Genlist_Item_Class *view_generic_create_genlist_item_class(const char *item_style, Elm_Genlist_Item_Text_Get_Cb on_text_get_cb, Elm_Genlist_Item_Del_Cb on_item_del_cb);
extern Evas_Object *view_generic_create_button(Evas_Object *parent, const char *target_part_name, const char *caption, Evas_Smart_Cb on_click_cb, void *data);
extern Evas_Object *view_generic_create_popup(Evas_Object *parent, const char *title);
extern Evas_Object *view_generic_create_toast(Evas_Object *parent, const char *text, double timeout);
extern Evas_Object *view_generic_create_image(Evas_Object *parent, const char *target_part_name, const char *file_path);
extern Evas_Object *view_generic_create_hoversel(Evas_Object *parent, const char *target_part_name);

#endif /* __generic_H__ */