#ifndef __view_H__
#define __view_H__

#include <Evas.h>
#include <Elementary.h>

typedef bool (*get_display_language_cb)(const char *locale, char **display_language);

struct __viewdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *layout_main_panel;
	Evas_Object *layout_language_top;
	Evas_Object *layout_text_middle;
	Evas_Object *layout_language_bottom;
	Evas_Object *hoversel;
	Evas_Object *button;
	get_display_language_cb get_language_cb;
};

typedef struct __viewdata viewdata_s;

extern bool view_create_base_gui(viewdata_s *vd, get_display_language_cb get_language_cb);
extern void view_destroy_base_gui(viewdata_s *vd);
extern bool view_add_locale(viewdata_s *vd, const char *locale);
extern bool view_set_language(viewdata_s *vd, const char *locale);

#endif /* __view_H__ */