#include <app_common.h>
#include <unistd.h>
#include "$(appName).h"
#include "model.h"
#include "controller.h"
#include "view/view.h"

static bool __get_display_language_cb(const char *locale, char **display_language)
{
	if (!display_language)
		return false;

	*display_language = NULL;

	return model_get_locale_display_language(locale, display_language);
}

static bool __get_available_locale_cb(const char *locale, void *data)
{
	viewdata_s *vd = (viewdata_s *)data;
	char fpath[512] = { 0, };
	char *res_path = app_get_resource_path();

	snprintf(fpath, sizeof(fpath), "%slocale/%s/LC_MESSAGES/$(appName).mo", res_path, locale);
	free(res_path);

	if (access(fpath, F_OK) != -1) {
		controller_log(DLOG_INFO, "Language supported: %s", locale);
		view_add_locale(vd, locale);
	}

	return true;
}

bool controller_init(viewdata_s *vd)
{
	if (!view_create_base_gui(vd, __get_display_language_cb))
		return false;

	if (!model_get_available_locale(__get_available_locale_cb, (void *)vd))
		return false;

	return true;
}

void controller_finit(viewdata_s *vd)
{
	view_destroy_base_gui(vd);
}

void controller_log(log_priority pri, const char *format, ...)
{
	va_list vl;

	va_start(vl, format);
	dlog_vprint(pri, LOG_TAG, format, vl);
	va_end(vl);
}
