#include <system_settings.h>
#include <utils_i18n.h>
#include "model.h"
#include "controller.h"

bool model_get_available_locale(get_available_locale_cb func_cb, void *data)
{
	if (!func_cb) {
		controller_log(DLOG_ERROR, "Wrong argument provided.");
		return false;
	}

	int i;
	int32_t count = i18n_ulocale_count_available();

	for (i = 0; i < count; i++) {
		const char *locale = i18n_ulocale_get_available(i);

		if (locale && !func_cb(locale, data))
			break;
	}

	return true;
}

bool model_get_locale_language(char **language)
{
	int ret = system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, language);
	if (ret != SYSTEM_SETTINGS_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function system_settings_get_value_string() failed with error %d.", ret);
		return false;
	}

	return true;
}

bool model_get_locale_display_language(const char *locale, char **display_language)
{
	i18n_uchar i18n_language[256] = {0,};

	if (!display_language) {
		controller_log(DLOG_ERROR, "Wrong argument provided.");
		return false;
	}

	i18n_ulocale_get_display_language(locale, NULL, i18n_language, sizeof(i18n_language));
	int ret = get_last_result();
	if (ret != I18N_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function i18n_ulocale_get_display_language() failed with error %d.", ret);
		return false;
	}

	int32_t str_len = i18n_ustring_get_length(i18n_language);
	*display_language = (char *)calloc(str_len + 1, sizeof(char));
	if (!(*display_language)) {
		controller_log(DLOG_ERROR, "Function calloc() failed.");
		return false;
	}

	i18n_ustring_copy_au_n(*display_language, i18n_language, str_len);
	ret = get_last_result();
	if (ret != I18N_ERROR_NONE) {
		free(*display_language);
		*display_language = NULL;
		controller_log(DLOG_ERROR, "Function i18n_ustring_copy_au_n() failed with error %d.", ret);
		return false;
	}

	return true;
}
