#include <Eina.h>
#include "$(appName).h"
#include "view/defines.h"
#include "view/generic.h"
#include "view/view.h"
#include "controller.h"

static viewdata_s *__viewdata = NULL;

static void __view_display_text_translation(viewdata_s *vd)
{
	elm_object_part_text_set(vd->layout_text_middle, PART_TEXT_MIDDLE_LABEL_TOP, i18n_get_text("IDS_BODY_EXAMPLE_TEXT"));
	elm_object_part_text_set(vd->layout_text_middle, PART_TEXT_MIDDLE_LABEL_BOTTOM, i18n_get_text("IDS_BODY_HELLO_WORLD"));
}

static void __view_select_hoversel_item_cb(void *data, Evas_Object *obj, void *event_info)
{
	char *locale = (char *)data;
	char *display_language = NULL;

	elm_object_text_set(__viewdata->hoversel, locale);

	if (!__viewdata->get_language_cb(locale, &display_language)) {
		elm_object_part_text_set(__viewdata->layout_language_bottom, PART_LANG_BOTTOM_CONTENT_LANGUAGE_LABEL, "Unknown language.");
		return;
	}

	elm_object_part_text_set(__viewdata->layout_language_bottom, PART_LANG_BOTTOM_CONTENT_LANGUAGE_LABEL, (const char *)display_language);
	free(display_language);
}

static void __view_apply_button_click_cb(void *data, Evas_Object *obj, void *event_info)
{
	const char *locale = elm_object_text_get(__viewdata->hoversel);
	viewdata_s *vd = (viewdata_s *)data;

	if (locale)
		view_set_language(vd, locale);
}

static void __view_delete_win_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static void __view_layout_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	viewdata_s *vd = (viewdata_s *)data;

	elm_win_lower(vd->win);
}

static bool __view_create_main_panel(viewdata_s *vd)
{
	vd->win = view_generic_create_window(__view_delete_win_request_cb);
	if (!vd->win)
		return false;

	vd->conform = view_generic_create_conformant(vd->win);
	if (!vd->conform)
		return false;

	vd->layout_main_panel = view_generic_create_set_layout(vd->conform, EDJ_MAIN_FILE_NAME, GROUP_MAIN, NULL);
	if (!vd->layout_main_panel)
		return false;

	eext_object_event_callback_add(vd->layout_main_panel, EEXT_CALLBACK_BACK, __view_layout_back_cb, (void *)vd);

	return true;
}

static bool __view_create_top_panel(viewdata_s *vd)
{
	vd->layout_language_top = view_generic_create_set_layout(vd->layout_main_panel, EDJ_LANG_TOP_FILE_NAME, GROUP_LANG_TOP, PART_MAIN_CONTENT_TOP);
	if (!vd->layout_language_top)
		return false;

	elm_object_part_text_set(vd->layout_language_top, PART_LANG_TOP_CONTENT_LABEL, "Go to the 'Settings application' &#10140; 'Language and input' &#10140; 'Display language' to change the language globally.");

	return true;
}

static bool __view_create_middle_text(viewdata_s *vd)
{
	vd->layout_text_middle = view_generic_create_set_layout(vd->layout_main_panel, EDJ_TEXT_MIDDLE_FILE_NAME, GROUP_TEXT_MIDDLE, PART_MAIN_CONTENT_TEXT);
	if (!vd->layout_text_middle)
		return false;

	/*__view_display_text_translation(vd); */
	elm_object_part_text_translatable_set(vd->layout_text_middle, PART_TEXT_MIDDLE_LABEL_TOP, EINA_TRUE);
	elm_object_part_text_translatable_set(vd->layout_text_middle, PART_TEXT_MIDDLE_LABEL_BOTTOM, EINA_TRUE);
	elm_object_translatable_part_text_set(vd->layout_text_middle, PART_TEXT_MIDDLE_LABEL_TOP, "IDS_BODY_EXAMPLE_TEXT");
	elm_object_translatable_part_text_set(vd->layout_text_middle, PART_TEXT_MIDDLE_LABEL_BOTTOM, "IDS_BODY_HELLO_WORLD");

	return true;
}

static bool __view_create_bottom_panel(viewdata_s *vd)
{
	vd->layout_language_bottom = view_generic_create_set_layout(vd->layout_main_panel, EDJ_LANG_BOTTOM_FILE_NAME, GROUP_LANG_BOTTOM, PART_MAIN_CONTENT_BOTTOM);
	if (!vd->layout_language_bottom)
		return false;

	vd->hoversel = view_generic_create_hoversel(vd->layout_language_bottom, PART_LANG_BOTTOM_CONTENT_LANGUAGES);
	if (!vd->hoversel)
		return false;

	vd->button = view_generic_create_button(vd->layout_language_bottom, PART_LANG_BOTTOM_CONTENT_BUTTON_PANEL_BUTTON, "Apply", __view_apply_button_click_cb, (void *)vd);
	if (!vd->button)
		return false;

	elm_object_part_text_set(vd->layout_language_bottom, PART_LANG_BOTTOM_CONTENT_LABEL, "Pick a language from drop down list and push the 'Apply' button to change the language locally.");

	return true;
}

bool view_create_base_gui(viewdata_s *vd, get_display_language_cb get_language_cb)
{
	__viewdata = vd;
	__viewdata->get_language_cb = get_language_cb;

	if (!__view_create_main_panel(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	if (!__view_create_top_panel(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	if (!__view_create_middle_text(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	if (!__view_create_bottom_panel(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	evas_object_show(vd->win);

	return true;
}

void view_destroy_base_gui(viewdata_s *vd)
{
	if (!vd)
		return;

	if (vd->win)
		evas_object_del(vd->win);
}

bool view_add_locale(viewdata_s *vd, const char *locale)
{
	if (!vd || !locale) {
		controller_log(DLOG_ERROR, "Invalid input arguments.");
		return false;
	}

	elm_hoversel_item_add(vd->hoversel, locale, NULL, ELM_ICON_NONE, __view_select_hoversel_item_cb, locale);

	return true;
}

bool view_set_language(viewdata_s *vd, const char *locale)
{
	if (!locale) {
		controller_log(DLOG_ERROR, "Invalid input arguments.");
		return false;
	}

	int str_len = strlen(locale) + strlen(".UTF-8") + 1;
	char *localization_string = (char *)calloc(str_len, sizeof(char));
	snprintf(localization_string, str_len, "%s.UTF-8", locale);

	controller_log(DLOG_INFO, "Language changed to: %s (%s)", locale, localization_string);

	elm_language_set(localization_string);
	free(localization_string);

	__view_display_text_translation(vd);

	return true;
}
