/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef NOTIFICATION_CONTROL_H_
#define NOTIFICATION_CONTROL_H_

#include <stdbool.h>
#include <notification.h>

#define TEXT_SHORT_LEN 256
#define TEXT_MAX_LEN 1024

typedef struct _notification_data notification_data;
typedef void (* notification_cb)(notification_data *);

struct _notification_data {
	char name[TEXT_SHORT_LEN];
	notification_h notification;
	int press_count;
	double progress_value;
	notification_cb callback;
	char result_text[TEXT_MAX_LEN];
};

/**
 * @brief get notification info
 * @param[out]   size   notification list size
 * @return notification info
 */
notification_data *notification_list_get(int *size);

/**
 * @brief Delete all notifications
 */
void delete_all_notifications();

/**
 * @brief get ongoing notification info
 * @param[out]   size   ongoing notification list size
 * @return ongoing notification info
 */
const notification_data *ongoing_notification_list_get(int *size);

/**
 * @brief Delete all ongoing notifications
 */
void delete_all_ongoing_notifications();

/**
 * @brief set arguments to service
 * @param[in]  notification   notification handle
 * @param[in]  argument	   service extra data info
 * @param[in]  pkgname		app name
 * @param[in]  uri_text	   uri info
 * @param[in]  mime_text	  mime info
 * @param[in]  operation	  operation info
 */
void launch_arguments_set(notification_h notification, const char *argument,
		const char *pkgname, const char *uri_text, const char *mime_text, const char *operation,
		const char **array_result, const char **array_key);

/**
 * @brief increase badge count by one. If the badge doesn't exist, then it is created.
 * @param[out]   count  badge count
 * @return true if success, false if failure
 */
bool increase_badge(unsigned int *count);

/**
 * @brief decrease badge count by one.
 * @param[out]   count  badge count
 * @return true if success, false if failure
 */
bool decrease_badge(unsigned int *count);


#endif /* NOTIFICATION_CONTROL_H_ */
