/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "utils/logger.h"
#include "utils/config.h"
#include "model/constants.h"
#include "model/notification-control.h"
#include <badge.h>
#include <Eina.h>

void launch_arguments_set(notification_h notification, const char *argument, const char *pkgname, const char *uri_text, const char *mime_text,
		const char *operation, const char **array_result, const char **array_key)
{
	app_control_h service = NULL;
	int err = app_control_create(&service);
	RETM_IF(err != SERVICE_ERROR_NONE, "service_create failure ");

	if (uri_text) {
		app_control_set_uri(service, uri_text);
	}
	if (mime_text) {
		app_control_set_mime(service, mime_text);
	}
	if (pkgname) {
		app_control_set_app_id(service, pkgname);
	}
	if (argument) {
		app_control_add_extra_data(service, MESSAGE_POST, argument);
	}
	if (operation) {
		app_control_set_operation(service, operation);
	}
	if (array_result && array_key) {
		int i = 0;
		for (; array_key[i] && array_result[i]; i++) {
			app_control_add_extra_data_array(service, array_key[i],
					&array_result[i], 1);
		}
	}

	notification_set_launch_option(notification,
			NOTIFICATION_LAUNCH_OPTION_APP_CONTROL, service);
	app_control_destroy(service);
}

bool increase_badge(unsigned int *count)
{
	RETVM_IF(!count, false, "count is NULL");

	int err = badge_get_count(PACKAGE, count);
	RETVM_IF(err != BADGE_ERROR_NONE, false, "badge_get_count() failed.");

	err = badge_set_count(PACKAGE, ++(*count));
	RETVM_IF(err != BADGE_ERROR_NONE, false, "badge_set_count() failed.");

	return (err == BADGE_ERROR_NONE);
}

bool decrease_badge(unsigned int *count)
{
	RETVM_IF(!count, false, "count is NULL");

	int err = badge_get_count(PACKAGE, count);
	RETVM_IF(err != BADGE_ERROR_NONE, false, "badge_get_count() failed.");

	if (*count > 0) {
		err = badge_set_count(PACKAGE, --(*count));
		RETVM_IF(err != BADGE_ERROR_NONE, false, "badge_set_count() failed.");
	}

	return (err == BADGE_ERROR_NONE);
}
