#ifndef __$(appName)_h__
#define __$(appName)_h__

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <dlog.h>

#include "conf.h"

typedef enum
{
	CLEAN = 0,
	SELECT,
	FREEHAND,
	RECTANGLE,
	CIRCLE,
	LINE,
	COLOR_SELECTOR,
	REMOVE,
} mode_type_t;


typedef struct
{
	const char *file_path;
	const char *tooltip;
	mode_type_t mode;
	Elm_Object_Item *item;
} icon_data_s;

typedef struct appdata
{
	Evas_Object *win;
	Evas_Object *layout;
	Evas_Object *conform;
	Evas_Object  *draw_area;

	Evas_Object *color_selector_panel;
	icon_data_s icon_data[IMAGE_POOL_SIZE];
} appdata_s;

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "$(appName)"

#if !defined(PACKAGE)
#define PACKAGE "$(packageName)"
#endif

#define EDJ_FILE "edje/$(appName).edj"
#define GRP_MAIN "main"


#endif /* __$(appName)_h__ */
