#ifndef __controller_H__
#define __controller_H__

#include <dlog.h>
#include "view.h"
#include "model.h"

extern bool controller_initialize(viewdata_s *vd, modeldata_s *md);
extern void controller_log(log_priority pri, const char *format, ...);
extern bool controller_set_preference(const char *key,
										const char *value,
										pref_value_type_t type);
extern bool controller_get_preference(const char *key,
										pref_value_type_t type,
										void **value);
extern bool controller_add_property_items_enum(const char *key_name,
												pref_value_type_t value_type);
extern bool controller_get_property_items_enum(Eina_List **properties_enum);
extern void controller_remove_key_value(key_value_t *key_value);
extern void controller_remove_key_value_list(Eina_List *list);
extern bool controller_check_same_string(char *str1, char *str2);
extern bool controller_remove_preference(const char *key);

#endif /* __controller_H__ */