#ifndef __model_H__
#define __model_H__

#include <Eina.h>

#define PROPERTY_ITEMS_ENUM_KEY "property-items"

typedef enum {PREF_INTEGER = 0,
				PREF_DOUBLE,
				PREF_BOOL,
				PREF_STRING,
				PREF_MAX} pref_value_type_t;

typedef struct _key_value {
	char *key;
	void *value;
	pref_value_type_t value_type;
} key_value_t;

typedef void (*preference_read_cb)(key_value_t *key_value);


typedef struct _modeldata {
	pref_value_type_t selected_pref_value_type;
} modeldata_s;


extern void model_create(modeldata_s *md,
							Eina_List *pref_types,
							preference_read_cb func_cb);
extern void model_set_preference_type_selected(
							pref_value_type_t pref_value_type);
extern pref_value_type_t model_get_preference_type_selected(void);
extern void model_select_preference_type(pref_value_type_t pref_value_type);
extern bool model_remove_preferences(void);
extern bool model_remove_preference(const char *key);
extern bool model_set_preference_int(const char *key, int value);
extern bool model_get_preference_int(const char *key, int *value);
extern bool model_set_preference_double(const char *key, double value);
extern bool model_get_preference_double(const char *key, double *value);
extern bool model_set_preference_bool(const char *key, bool value);
extern bool model_get_preference_bool(const char *key, bool *value);
extern bool model_set_preference_string(const char *key, const char *value);
extern bool model_get_preference_string(const char *key, char **value);
extern bool model_check_preference_exists(const char *key);

#endif /* __model_H__ */