/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <dlog.h>

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "puzzle"

#if !defined(PACKAGE)
#define PACKAGE "org.tizen.puzzle"
#endif

#define PUZZLE_EDJ "/edje/puzzle.edj"
#define SMILE_IMG "smile.jpg"
#define CORRECT_IMG "correct.jpg"
#define GRP_MAIN "main"
#define GRP_MENU "menu"
#define GRP_DIR_BTN "dir_btn"
#define MAX_PATH_LEN 1024
#define PUZZLE_RATIO 0.6
#define MENU_RATIO 0.2

typedef enum {
      SAMPLE_APP_ERROR_OK = 0,
      SAMPLE_APP_ERROR_FAIL = -1,

      SAMPLE_APP_ERROR_INVALID_PARAMETER = -2,
      SAMPLE_APP_ERROR_OUT_OF_MEMORY = -3,
      SAMPLE_APP_ERROR_NO_DATA = -4,
} sample_app_error_e;

typedef struct appdata{
	Evas_Object *win;
	Evas_Object *layout;
	Evas_Object *conform;

	Evas_Object *piece[37];
	int piece_pos[37];

	Evas_Object *check1, *check2;

	Evas* e;

	char puzzle_edj_path[MAX_PATH_LEN];
	char smile_img_path[MAX_PATH_LEN];
	char correct_img_path[MAX_PATH_LEN];
	int full_image_width, full_image_height;
	int origin_image_width, origin_image_height;
	int puzzle_start_x, puzzle_start_y;
	int white_piece, size;
	int screen_width, screen_height;
	int r, g, b, a;
	int start;
	int shuffling;
	int shuffle_count;
} appdata_s;

Evas_Object *menu_create(appdata_s *data, Evas_Object *layout);
Evas_Object *dir_btn_create(appdata_s *data, Evas_Object *layout);
void puzzle_create(appdata_s *data);
void puzzle_correct_cb(appdata_s *data);
int puzzle_change(appdata_s *data, int level);
void move_up_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
void move_down_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
void move_left_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
void move_right_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
int move_puzzle_to_up(void *data);
int move_puzzle_to_down(void *data);
int move_puzzle_to_left(void *data);
int move_puzzle_to_right(void *data);
void move_shuffle_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
void mouse_down_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
void mouse_up_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
void icon_button_clicked_cb(void *data, Evas_Object *obj, void *event_info);
void icon_answer_cb(void *data, Evas *e, Evas_Object *obj, void *event_info);
void icon_level_cb(void* data, Evas *e, Evas_Object *obj, void *event_info);
void get_resource_path(appdata_s *ad);
