/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"
#include "log.h"

void _check_cb(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
	ret_if(!data);

	Evas_Object *another_check = data;
	Evas_Object *clicked = obj;
	Eina_Bool check1, check2;

	check1 = elm_check_state_get(clicked);
	check2 = elm_check_state_get(another_check);

	if(check1 == 0 && check2 == 1) {
		elm_check_state_set(another_check, EINA_FALSE);
	}
}

void icon_button_clicked_cb(void *data, Evas_Object *obj, void *event_info)
{
	ret_if(!data);

	Evas_Object *popup = data;

	evas_object_del(popup);
}

void icon_answer_cb(void *data, Evas *e, Evas_Object *obj,  void *event_info)
{
	ret_if(!data);

	appdata_s *ad = data;
	Evas_Object *popup = NULL;
	Evas_Object *layout = NULL;
	Evas_Object *btn = NULL;
	Evas_Object *img = NULL;

	popup = elm_popup_add(ad->win);
	elm_popup_align_set(popup, ELM_NOTIFY_ALIGN_FILL, 1.0);

	eext_object_event_callback_add(popup, EEXT_CALLBACK_BACK, eext_popup_back_cb, NULL);
	elm_object_part_text_set(popup, "title,text", "Answer");
	evas_object_size_hint_weight_set(popup, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);

	layout = elm_layout_add(popup);
	elm_layout_file_set(layout, ad->puzzle_edj_path, "popup_image_list_layout");
	evas_object_size_hint_weight_set(layout, 0, 0);
	evas_object_size_hint_align_set(layout, 0, EVAS_HINT_FILL);
	elm_object_content_set(popup, layout);

	/* image */
	img = elm_image_add(layout);
	elm_image_file_set(img, ad->smile_img_path, NULL);
	elm_image_aspect_fixed_set(img, EINA_FALSE);

	evas_object_size_hint_min_set(img, 400, 400);
	evas_object_size_hint_max_set(img, 400, 400);
	elm_object_part_content_set(layout, "elm.swallow.content", img);

	/* ok button */
	btn = elm_button_add(popup);
	elm_object_style_set(btn, "popup");
	elm_object_text_set(btn, "OK");
	elm_object_part_content_set(popup, "button1", btn);
	evas_object_smart_callback_add(btn, "clicked", icon_button_clicked_cb, popup);
	evas_object_show(popup);
}

void _level_button_cb(void *data, Evas_Object *obj, void *event_info)
{
	ret_if(!data);

	appdata_s *ad = data;
	Evas_Object *popup = NULL;

	popup = evas_object_data_get(ad->win, "popup");

	if(elm_check_state_get(ad->check1) == 1) {
		if(!puzzle_change(ad, 4)) {
			_E("Fail puzzle change");
		}
	} else if(elm_check_state_get(ad->check2) == 1) {
		if(!puzzle_change(ad, 5)) {
			_E("Fail puzzle change");
		}
	}

	evas_object_del(popup);
}

void icon_level_cb(void* data, Evas *e, Evas_Object *obj, void *event_info)
{
	ret_if(!data);

	appdata_s *ad = data;
	Evas_Object *popup = NULL;
	Evas_Object *layout = NULL;
	Evas_Object *btn = NULL;
	Evas_Object *win = NULL;

	win = ad->win;

	popup = elm_popup_add(win);
	elm_popup_align_set(popup, ELM_NOTIFY_ALIGN_FILL, 1.0);
	eext_object_event_callback_add(popup, EEXT_CALLBACK_BACK, eext_popup_back_cb, NULL);
	elm_object_part_text_set(popup, "title,text", "Level");
	evas_object_size_hint_weight_set(popup, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);

	/* layout */
	layout = elm_layout_add(popup);
	elm_layout_file_set(layout, ad->puzzle_edj_path, "popup_checkview_layout");
	evas_object_size_hint_weight_set(layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(layout, 0, EVAS_HINT_FILL);
	elm_object_content_set(popup, layout);

	/* check1 */
	ad->check1 = elm_check_add(popup);
	elm_object_style_set(ad->check1, "popup");
	evas_object_size_hint_align_set(ad->check1, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_weight_set(ad->check1, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(layout, "check1", ad->check1);

	/* check2 */
	ad->check2 = elm_check_add(popup);
	elm_object_style_set(ad->check2, "popup");
	evas_object_size_hint_align_set(ad->check2, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_weight_set(ad->check2, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(layout, "check2", ad->check2);

	evas_object_event_callback_add(ad->check1, EVAS_CALLBACK_MOUSE_UP, _check_cb, ad->check2);
	evas_object_event_callback_add(ad->check2, EVAS_CALLBACK_MOUSE_UP, _check_cb, ad->check1);

	/* save button */
	btn = elm_button_add(popup);
	elm_object_style_set(btn, "popup");
	elm_object_text_set(btn, "OK");
	elm_object_part_content_set(popup, "button1", btn);
	evas_object_data_set(ad->win,"popup",popup);
	evas_object_smart_callback_add(btn, "clicked", _level_button_cb, ad);

	/* cancel button */
	btn = elm_button_add(popup);
	elm_object_style_set(btn, "popup");
	elm_object_text_set(btn, "Cancel");
	elm_object_part_content_set(popup, "button2", btn);
	evas_object_smart_callback_add(btn, "clicked", icon_button_clicked_cb, popup);

	evas_object_show(popup);
}

Evas_Object *menu_create(appdata_s *ad, Evas_Object *layout)
{
	_D("menu_create");
	retv_if(!ad, NULL);

	Evas_Object *menu = NULL;
	Evas_Object *answer = NULL;
	Evas_Object *level = NULL;
	Evas_Object *shuffle = NULL;

	menu = elm_layout_add(ad->win);
	retv_if(!menu, NULL);
	evas_object_size_hint_weight_set(menu, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_layout_file_set(menu, ad->puzzle_edj_path, GRP_MENU);

	answer = elm_icon_add(menu);
	retv_if(!answer, NULL);
	elm_icon_standard_set(answer, "no_photo");
	elm_object_part_content_set(menu, "answer", answer);
	evas_object_event_callback_add(answer, EVAS_CALLBACK_MOUSE_UP, icon_answer_cb, ad);

	level = elm_icon_add(menu);
	retv_if(!level, NULL);
	elm_icon_standard_set(level, "file");
	elm_object_part_content_set(menu, "level", level);
	evas_object_event_callback_add(level, EVAS_CALLBACK_MOUSE_UP, icon_level_cb, ad);

	shuffle = elm_icon_add(menu);
	retv_if(!shuffle, NULL);
	elm_icon_standard_set(shuffle, "refresh");
	elm_object_part_content_set(menu, "shuffle", shuffle);
	evas_object_event_callback_add(shuffle, EVAS_CALLBACK_MOUSE_UP, move_shuffle_cb, ad);

	elm_object_part_content_set(layout, "menu", menu);

	return menu;
}
