/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * puzzle.c
 *
 *  Created on: Feb 5, 2015
 *      Author: beomseok1.oh
 */

#include "main.h"
#include "log.h"

int puzzle_change(appdata_s *data, int level)
{
	retv_if(!data, -1);

	appdata_s *ad = data;
	int x, y;
	int extract_region_width, extract_region_height;
	int puzzle_width, puzzle_height;
	int PIECE = level;
	int i;

	for(i = 0; i < 36; i++)
	{
		evas_object_color_set(ad->piece[i], ad->r, ad->g, ad->b, 0);
		evas_object_show(ad->piece[i]);
		evas_object_move(ad->piece[i], 0, 0);
	}

	extract_region_width = ad->origin_image_width/PIECE;
	extract_region_height = ad->origin_image_height/PIECE;
	puzzle_width = ad->full_image_width/PIECE;
	puzzle_height = ad->full_image_height/PIECE;
	_D("Extract region width: %d, height: %d", extract_region_width, extract_region_height);
	_D("Puzzle width: %d, height: %d", extract_region_width, extract_region_height);

	for(y = 0; y < PIECE; y++)
	{
		for(x = 0; x < PIECE; x++)
		{
			evas_object_color_set(ad->piece[y*PIECE + x], ad->r, ad->g, ad->b, 255);
			evas_object_image_file_set(ad->piece[y*PIECE + x], ad->smile_img_path, NULL);

			evas_object_move(ad->piece[y*PIECE + x], ad->puzzle_start_x + x*(2+puzzle_width), ad->puzzle_start_y + y*(2+puzzle_height));
			evas_object_image_load_region_set(ad->piece[y*PIECE + x], x*extract_region_width, y*extract_region_height, extract_region_width, extract_region_height);
			evas_object_resize(ad->piece[y*PIECE + x], puzzle_width, puzzle_height);

			evas_object_event_callback_add(ad->piece[y*PIECE + x], EVAS_CALLBACK_MOUSE_DOWN, mouse_down_cb, ad);
			evas_object_event_callback_add(ad->piece[y*PIECE + x], EVAS_CALLBACK_MOUSE_UP, mouse_up_cb, ad);

			if (y == (PIECE - 1) && x == (PIECE - 1)) {
				evas_object_color_get(ad->piece[y*PIECE + x], &ad->r, &ad->g, &ad->b, &ad->a);
				evas_object_color_set(ad->piece[y*PIECE + x], ad->r, ad->g, ad->b, 0);

				ad->white_piece = y*PIECE + x;
			}

			evas_object_show(ad->piece[y*PIECE + x]);
		}
	}
	ad->size = PIECE;
	ad->start = 0;

	return SAMPLE_APP_ERROR_OK;
}
void puzzle_correct_cb(appdata_s *data)
{
	ret_if(!data);

	appdata_s *ad = data;
	Evas_Object *popup = NULL;
	Evas_Object *layout = NULL;
	Evas_Object *img = NULL;
	Evas_Object *btn = NULL;
	Evas_Object *win = NULL;
	int i;

	win = ad->win;

	for(i = 0; i < ad->size * ad->size; i++)
	{
		if(ad->piece_pos[i]!=i) {
			return;
		}
	}

	popup = elm_popup_add(win);
	elm_popup_align_set(popup, ELM_NOTIFY_ALIGN_FILL, 1.0);

	eext_object_event_callback_add(popup, EEXT_CALLBACK_BACK, eext_popup_back_cb, NULL);
	elm_object_part_text_set(popup, "title,text", "Correct!!");
	evas_object_size_hint_weight_set(popup, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);

	layout = elm_layout_add(popup);
	elm_layout_file_set(layout, ad->puzzle_edj_path, "popup_image_list_layout");
	evas_object_size_hint_weight_set(layout, 0, 0);
	evas_object_size_hint_align_set(layout, 0, EVAS_HINT_FILL);
	elm_object_content_set(popup, layout);

	/* image */
	img = elm_image_add(layout);
	elm_image_file_set(img, ad->correct_img_path, NULL);
	elm_image_aspect_fixed_set(img, EINA_FALSE);

	evas_object_size_hint_min_set(img, 400, 400);
	evas_object_size_hint_max_set(img, 400, 400);
	elm_object_part_content_set(layout, "elm.swallow.content", img);

	/* ok button */
	btn = elm_button_add(popup);
	elm_object_style_set(btn, "popup");
	elm_object_text_set(btn, "OK");
	elm_object_part_content_set(popup, "button1", btn);
	evas_object_smart_callback_add(btn, "clicked", icon_button_clicked_cb, popup);
	evas_object_show(popup);

	ad->start = 0;
}

#define PIECE 4
void puzzle_create(appdata_s *data)
{
	_D("Puzzle_create");
	ret_if(!data);

	appdata_s *ad = data;
	int x, y;
	int extract_region_width, extract_region_height;
	int puzzle_width, puzzle_height;
	int i;
	int ret;

	ad->full_image_width = ad->screen_width - (6 + 6);
	ad->full_image_height = (ad->screen_height * PUZZLE_RATIO) - (6 + 6);
	ad->puzzle_start_x = 6;
	ad->puzzle_start_y = (ad->screen_height * MENU_RATIO) + 6;

	for(i = 0; i < 37; i++)
	{
		ad->piece[i] = evas_object_image_filled_add(ad->e);
		ad->piece_pos[i] = i;
		evas_object_image_file_set(ad->piece[i], ad->smile_img_path, NULL);
		ret = evas_object_image_load_error_get(ad->piece[i]);
		if (ret != EVAS_LOAD_ERROR_NONE) {
			_E("Failed to load image");
		}
		evas_object_data_set(ad->piece[i], "position", (void *)i);
	}
	evas_object_image_size_get(ad->piece[36], &ad->origin_image_width, &ad->origin_image_height);
	_D("The original image width: %d, height: %d", ad->origin_image_width, ad->origin_image_height);

	extract_region_width = ad->origin_image_width/PIECE;
	extract_region_height = ad->origin_image_height/PIECE;
	puzzle_width = ad->full_image_width/PIECE;
	puzzle_height = ad->full_image_height/PIECE;
	_D("Extract region width: %d, height: %d", extract_region_width, extract_region_height);
	_D("Puzzle width: %d, height: %d", puzzle_width, puzzle_height);

	for(y = 0; y < PIECE; y++)
	{
		for(x = 0; x < PIECE; x++)
		{
			evas_object_move(ad->piece[y*PIECE + x], ad->puzzle_start_x + x*(2+puzzle_width), ad->puzzle_start_y + y*(2+puzzle_height));
			evas_object_image_load_region_set(ad->piece[y*PIECE + x], x*extract_region_width, y*extract_region_height, extract_region_width, extract_region_height);
			evas_object_resize(ad->piece[y*PIECE + x], puzzle_width, puzzle_height);

			evas_object_event_callback_add(ad->piece[y*PIECE + x], EVAS_CALLBACK_MOUSE_DOWN, mouse_down_cb, ad);
			evas_object_event_callback_add(ad->piece[y*PIECE + x], EVAS_CALLBACK_MOUSE_UP, mouse_up_cb, ad);

			if (y == 3 && x == 3) {
				evas_object_color_get(ad->piece[y*PIECE + x], &ad->r, &ad->g, &ad->b, &ad->a);
				evas_object_color_set(ad->piece[y*PIECE + x], ad->r, ad->g, ad->b, 0);

				ad->white_piece = y*PIECE + x;
			}

			evas_object_show(ad->piece[y*PIECE + x]);
		}
	}
	ad->size = PIECE;
	ad->start = 0;
}

