#include "$(appName).h"
#include "model.h"
#include "controller.h"
#include "view/view.h"

static bool __controller_get_relative_resource_file_path(const char *file_path, const char **rel_file_path)
{
	if (!rel_file_path)
		return false;

	char *res_path = app_get_resource_path();

	*rel_file_path = NULL;

	if ((unsigned int)strstr(file_path, res_path) == (unsigned int)file_path) {
		*rel_file_path = file_path + strlen(res_path);
	} else {
		return false;
	}

	free(res_path);

	return true;
}

static void __controller_init_dpi(viewdata_s *vd)
{
	char *file_path = NULL;

	if (!model_get_app_resource(APP_RESOURCE_TYPE_IMAGE, "tizen.png", &file_path))
		return;

	view_show_dpi_image(vd, file_path);

	if (file_path)
		free(file_path);
}

bool controller_init(viewdata_s *vd)
{
	if (!model_init())
		return false;

	if (!view_create_base_gui(vd))
		return false;

	__controller_init_dpi(vd);

	return true;
}

void controller_finit(viewdata_s *vd)
{
	model_finit();
	view_destroy_base_gui(vd);
}

void controller_set_language(viewdata_s *vd)
{
	char *file_path = NULL;

	if (model_get_app_resource(APP_RESOURCE_TYPE_LAYOUT, "language.edj", &file_path)) {
		const char *rel_file_path = NULL;

		if (__controller_get_relative_resource_file_path(file_path, &rel_file_path))
			view_show_language_layout(vd, rel_file_path);
	}

	free(file_path);
	file_path = NULL;

	if (model_get_app_resource(APP_RESOURCE_TYPE_IMAGE, "flag.png", &file_path))
		view_show_language_info(vd, file_path);

	free(file_path);
}

void controller_log(log_priority pri, const char *format, ...)
{
	va_list vl;

	va_start(vl, format);
	dlog_vprint(pri, LOG_TAG, format, vl);
	va_end(vl);
}
