#include <app.h>
#include <system_settings.h>
#include "model.h"
#include "controller.h"

bool __model_init_app_resource_manager(void)
{
	int ret = app_resource_manager_init();
	if (ret != APP_RESOURCE_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_resource_manager_init() failed with error %d.", ret);
		return false;
	}

	return true;
}

bool __model_release_app_resource_manager(void)
{
	int ret = app_resource_manager_release();
	if (ret != APP_RESOURCE_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_resource_manager_release() failed with error %d.", ret);
		return false;
	}

	return true;
}

bool model_init(void)
{
	return __model_init_app_resource_manager();
}

bool model_finit(void)
{
	return __model_release_app_resource_manager();
}

bool model_get_app_resource(app_resource_e type, const char *id, char **path)
{
	*path = NULL;

	int ret = app_resource_manager_get(type, id, path);
	if (ret != APP_RESOURCE_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_resource_manager_get() failed with error %d.", ret);
		return false;
	}

	return true;
}

bool model_get_locale(char **locale)
{
	*locale = NULL;

	int ret = system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, locale);
	if (ret != SYSTEM_SETTINGS_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function system_settings_get_value_string() failed with error %d.", ret);
		return false;
	}

	return (*locale != NULL);
}