#include "$(appName).h"
#include "view/defines.h"
#include "view/generic.h"
#include "view/view.h"
#include "controller.h"

static viewdata_s *__viewdata = NULL;

static void __view_delete_win_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static void __view_layout_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	viewdata_s *vd = (viewdata_s *)data;

	elm_win_lower(vd->win);
}

static bool __view_create_main_panel(viewdata_s *vd)
{
	vd->win = view_generic_create_window(__view_delete_win_request_cb);
	if (!vd->win)
		return false;

	vd->conform = view_generic_create_conformant(vd->win);
	if (!vd->conform)
		return false;

	vd->layout_main_panel = view_generic_create_set_layout(vd->conform, EDJ_MAIN_FILE_NAME, GROUP_MAIN, NULL);
	if (!vd->layout_main_panel)
		return false;

	eext_object_event_callback_add(vd->layout_main_panel, EEXT_CALLBACK_BACK, __view_layout_back_cb, (void *)vd);

	vd->image_dpi = view_generic_create_image(vd->layout_main_panel, PART_MAIN_TOP_PANEL, NULL);
	if (!vd->image_dpi)
		return false;

	vd->image_language = view_generic_create_image(vd->layout_main_panel, PART_MAIN_BOTTOM_PANEL_IMAGE, NULL);
	if (!vd->image_language)
		return false;

	vd->layout_language = view_generic_create_set_layout(vd->layout_main_panel, EDJ_LANGUAGE_FILE_NAME, GROUP_LANGUAGE, PART_MAIN_BOTTOM_PANEL_LANGUAGE_PANEL);
	if (!vd->layout_language)
		return false;

	return true;
}

bool view_create_base_gui(viewdata_s *vd)
{
	__viewdata = vd;

	if (!__view_create_main_panel(vd)) {
		evas_object_del(vd->win);
		return false;
	}

	evas_object_show(vd->win);

	return true;
}

void view_destroy_base_gui(viewdata_s *vd)
{
	if (!vd)
		return;

	if (vd->win)
		evas_object_del(vd->win);
}

void view_show_dpi_image(viewdata_s *vd, const char *file_path)
{
	if (!file_path) {
		controller_log(DLOG_ERROR, "Invalid input arguments.");
		return;
	}

	controller_log(DLOG_INFO, "DPI image path: %s.", file_path);

	if (!elm_image_file_set(vd->image_dpi, file_path, NULL)) {
		controller_log(DLOG_ERROR, "Function elm_image_file_set() failed for file %s.", file_path);
		return;
	}
}

void view_show_language_layout(viewdata_s *vd, const char *file_path)
{
	if (!file_path) {
		controller_log(DLOG_ERROR, "Invalid input arguments.");
		return;
	}

	controller_log(DLOG_INFO, "Layout path: %s.", file_path);

	Evas_Object *layout = elm_object_part_content_unset(vd->layout_main_panel, PART_MAIN_BOTTOM_PANEL_LANGUAGE_PANEL);
	evas_object_del(layout);

	vd->layout_language = view_generic_create_set_layout(vd->layout_main_panel, file_path, GROUP_LANGUAGE, PART_MAIN_BOTTOM_PANEL_LANGUAGE_PANEL);
}

void view_show_language_info(viewdata_s *vd, const char *file_path)
{
	if (!file_path) {
		controller_log(DLOG_ERROR, "Invalid input arguments.");
		return;
	}

	controller_log(DLOG_INFO, "Language image path: %s.", file_path);

	if (!elm_image_file_set(vd->image_language, file_path, NULL)) {
		controller_log(DLOG_ERROR, "Function elm_image_file_set() failed for file %s.", file_path);
		return;
	}
}