#include "page_scroller.h"

#include "$(appName).h"
#include "conf.h"

static void __fill_scroller(Evas_Object *page_scroller, int p_w, int p_h);
static Evas_Object *__create_scroller_box(Evas_Object *page_scroller);
static void __add_scroller_page(Evas_Object *pages_scroller_box,
	int p_w, int p_h, int r, int g, int b);


Evas_Object *
page_scroller_create(Evas_Object *parent, int p_width, int p_height)
{
	Evas_Object *page_scroller = NULL;

	if (!parent) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Invalid parameter : parent = NULL");
		return NULL;
	}

	page_scroller = elm_scroller_add(parent);
	if (!page_scroller) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failed to create page scroller");
		return NULL;
	}

	elm_scroller_page_size_set(page_scroller, p_width, p_height);
	elm_scroller_content_min_limit(page_scroller, EINA_FALSE, EINA_FALSE);
	elm_scroller_bounce_set(page_scroller, EINA_FALSE, EINA_TRUE);
	elm_scroller_policy_set(page_scroller, ELM_SCROLLER_POLICY_OFF,
		ELM_SCROLLER_POLICY_OFF);
	elm_scroller_page_scroll_limit_set(page_scroller, 1, 1);
	elm_scroller_loop_set(page_scroller, EINA_TRUE, EINA_FALSE);
	__fill_scroller(page_scroller, p_width, p_height);

	evas_object_show(page_scroller);
	return page_scroller;
}

int
page_scroller_get_page_count(Evas_Object *page_scroller)
{
	Eina_List *list = NULL;
	Evas_Object *box = NULL;

	if (!page_scroller) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid function param : page_scroller is NULL");
		return -1;
	}

	box = elm_object_content_get(page_scroller);
	if (!box) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to get page scroller box widget");
		return -1;
	}

	list = elm_box_children_get(box);
	if (!list) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to get list");
		return -1;
	}

	return eina_list_count(list);
}

int
page_scroller_get_current_page_number(Evas_Object *page_scroller)
{
	int page_num = -1;

	if (!page_scroller) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid parameter : page_scroller is NULL");
		return -1;
	}

	elm_scroller_current_page_get(page_scroller, &page_num, NULL);
	return page_num;
}

static void
__fill_scroller(Evas_Object *page_scroller, int p_w, int p_h)
{
	Evas_Object *box = NULL;

	if (!page_scroller) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid parameter : page_scroller = NULL");
		return;
	}

	box = __create_scroller_box(page_scroller);
	if (!box) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to create box");
		return;
	}

	elm_object_part_content_set(page_scroller, "default", box);


	__add_scroller_page(box, p_w, p_h, 255, 0, 0);
	__add_scroller_page(box, p_w, p_h, 0, 255, 0);
	__add_scroller_page(box, p_w, p_h, 0, 0, 255);
	__add_scroller_page(box, p_w, p_h, 0, 255, 255);
}

static Evas_Object *
__create_scroller_box(Evas_Object *page_scroller)
{
	Evas_Object *box = NULL;

	if (!page_scroller) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid parameter : page_scroller is NULL");
		return NULL;
	}

	box = elm_box_add(page_scroller);
	if (!box) {
		dlog_print(DLOG_ERROR, LOG_TAG, "box creation failed");
		return NULL;
	}

	elm_box_horizontal_set(box, EINA_TRUE);
	elm_box_align_set(box, 0.5, 0.5);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND,
		EVAS_HINT_EXPAND);
	evas_object_show(box);

	return box;
}

static void
__add_scroller_page(Evas_Object *pages_container_box, int p_w, int p_h,
	int r, int g, int b)
{
	Evas_Object *page = NULL;
	Evas_Object *page_bg = NULL;
	static int page_no = 0;

	char edj_path[PATH_MAX] = {0, };
	char page_name[PATH_MAX] = {0, };

	if (!pages_container_box) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid parameter : page_scroller");
		return;
	}

	page_bg = evas_object_rectangle_add(
		evas_object_evas_get(pages_container_box));
	if (!page_bg) {
		dlog_print(DLOG_ERROR, LOG_TAG, "page bg creation failed");
		return;
	}
	evas_object_color_set(page_bg, r, g, b, 255);

	evas_object_resize(page_bg, p_w, p_h);
	evas_object_size_hint_min_set(page_bg, p_w, p_h);

	page = elm_layout_add(pages_container_box);
	if (!page) {
		dlog_print(DLOG_ERROR, LOG_TAG, "page creation failed");
		evas_object_del(page_bg);
		return;
	}

	get_app_resource(EDJ_FILE, edj_path, (int)PATH_MAX);

	if (!elm_layout_file_set(page, edj_path, GROUP_PAGE)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to set page!");
		evas_object_del(page_bg);
		evas_object_del(page);
		return;
	}

	snprintf(page_name, sizeof(page_name), "PAGE %d", page_no++);
	elm_object_part_text_set(page, PART_TEXT_PAGE_NAME, page_name);

	elm_object_part_content_set(page, PART_SWALLOW_PAGE_BG, page_bg);
	elm_box_pack_end(pages_container_box, page);
	evas_object_show(page);
}
