#include "$(appName).h"
#include "view.h"
#include "conf.h"

void
get_app_resource(const char *edj_file_in, char *edj_path_out, int edj_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(edj_path_out, edj_path_max, "%s%s",
			res_path, edj_file_in);
		free(res_path);
	}
}

static bool
__create_app(void *data)
{
	/* Hook to take necessary actions before main event loop starts
	   Initialize UI resources and application's data
	   If this function returns true, the main loop of application starts
	   If this function returns false, the application is terminated */
	appdata_s *ad = data;
	return view_create(ad);
}

static void
__control_app(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
__pause_app(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
__resume_app(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
__terminate_app(void *data)
{
	/* Release all resources. */
	view_destroy((appdata_s *) data);
}

static void
__ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE,
		&locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
__ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	return;
}

static void
__ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
__ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
__ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])
{
	dlog_print(DLOG_INFO, LOG_TAG, "starting applicaiton");

	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = __create_app;
	event_callback.terminate = __terminate_app;
	event_callback.pause = __pause_app;
	event_callback.resume = __resume_app;
	event_callback.app_control = __control_app;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY],
		APP_EVENT_LOW_BATTERY, __ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY],
		APP_EVENT_LOW_MEMORY, __ui_app_low_memory, &ad);
	ui_app_add_event_handler(
		&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED],
		APP_EVENT_DEVICE_ORIENTATION_CHANGED, __ui_app_orient_changed,
		&ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED],
		APP_EVENT_LANGUAGE_CHANGED, __ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED],
		APP_EVENT_REGION_FORMAT_CHANGED, __ui_app_region_changed, &ad);
	ui_app_remove_event_handler(handlers[APP_EVENT_LOW_MEMORY]);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE)
		dlog_print(DLOG_ERROR, LOG_TAG,
			"ui_app_main() is failed. err = %d", ret);

	return ret;
}
