#include "view.h"
#include "$(appName).h"
#include "conf.h"
#include "page_scroller.h"
#include "index.h"


/*========================= LOCAL FUNCTIONS ==================================*/
static bool __win_create(appdata_s *ad);
static bool __conformant_create(appdata_s *ad);
static bool __layout_create(appdata_s *ad);

/*========================= CALLBACK FUNCTIONS ===============================*/
static void __win_delete_cb(void *data, Evas_Object *obj, void *event_info);
static void __layout_back_cb(void *data, Evas_Object *obj, void *event_info);

/*========================= PUBLIC FUNCTIONS =================================*/
bool
view_create(appdata_s *ad)
{
	if (!ad) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid application data struct");
		return false;
	}

	if (!__win_create(ad)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid application data struct");
		return false;
	}
	if (!__conformant_create(ad)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid application data struct");
		return false;
	}
	if (!__layout_create(ad)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "invalid application data struct");
		return false;
	}

	return true;
}

void
view_destroy(appdata_s *ad)
{
	if (!ad)
		return;
	if (ad->index_cb_data)
		free(ad->index_cb_data);
	if (ad->win)
		evas_object_del(ad->win);
}

/*========================= LOCAL FUNCTIONS ==================================*/
static bool
__win_create(appdata_s *ad)
{
	if (!ad) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ad struct is not allocated!");
		return false;
	}

	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	if (!ad->win) {
		dlog_print(DLOG_ERROR, LOG_TAG, "win createion failed");
		return false;
	}

	elm_win_conformant_set(ad->win, EINA_TRUE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win,
			(const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "delete,request",
		__win_delete_cb, NULL);

	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_HIDE);
	evas_object_show(ad->win);

	return true;
}

static bool
__conformant_create(appdata_s *ad)
{
	if (!ad) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ad struct is not allocated");
		return false;
	}

	ad->conform = elm_conformant_add(ad->win);
	if (!ad->conform) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to  create conformant");
		return false;
	}

	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND,
		EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	return true;
}

static bool
__layout_create(appdata_s *ad)
{
	Evas_Object *page_scroller = NULL;
	Evas_Object *index = NULL;

	int w = -1;
	int h = -1;

	elm_win_screen_size_get(ad->win, NULL, NULL, &w, &h);

	char edj_path[PATH_MAX] = {0, };
	if (!ad) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ad struct is not allocated");
		return false;
	}

	get_app_resource(EDJ_FILE, edj_path, (int)PATH_MAX);
	ad->layout = elm_layout_add(ad->win);
	if (!ad->layout) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to create layout");
		return false;
	}

	if (!elm_layout_file_set(ad->layout, edj_path, GROUP_MAIN)) {
		dlog_print(DLOG_ERROR, LOG_TAG, "faile to set layout");
		return false;
	}

	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND,
		EVAS_HINT_EXPAND);
	eext_object_event_callback_add(ad->layout, EEXT_CALLBACK_BACK,
		__layout_back_cb, ad);
	elm_object_content_set(ad->conform, ad->layout);
	evas_object_show(ad->layout);

	page_scroller = page_scroller_create(ad->layout, w, h * 0.9);
	if (!page_scroller) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to create page scroller");
		return false;
	}

	elm_object_part_content_set(ad->layout, PART_SWALLOW_SCROLLER,
		page_scroller);

	index = index_create(page_scroller, ad->index_cb_data);
	if (!index) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to create index scroller");
		return false;
	}

	elm_object_part_content_set(ad->layout, PART_SWALLOW_INDEX, index);

	return true;
}

/*========================= CALLBACK FUNCTIONS ===============================*/
static void
__win_delete_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static void
__layout_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = (appdata_s *) data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}
