#ifndef __PAGE_SCROLLER_H__
#define __PAGE_SCROLLER_H__

#include <Elementary.h>

/**
 * @brief Creates elm_scroller widget with 4 pages
 *
 * @param parent Pointer to the parent widget
 * @param p_width width of scroller page
 * @param p_height height of scroller page
 * @return pointer to elm_scroller object
 */
Evas_Object *page_scroller_create(Evas_Object *parent, int p_width,
	int p_height);

/**
 * @brief Gets scroller pages count
 *
 * @param page_scroller Pointer to page scroller object
 * @return Number of pages or -1 if something went wrong.
 */
int page_scroller_get_page_count(Evas_Object *page_scroller);

/**
 * @brief Returns current page number
 *
 * @param page_scroller pointer to page scroller widget
 * @return current page number or -1 if something went wrong
 */
int page_scroller_get_current_page_number(Evas_Object *page_scroller);

#endif
