/*
 * Copyright (c) 2014-2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __SENSOR_INFO_H__
#define __SENSOR_INFO_H__

#include <sensor.h>

/**
 * @brief Measurement units for sensors
 */
typedef enum {
	SENSOR_UNIT_METRE_PER_SECOND_SQUARED,
	SENSOR_UNIT_MICRO_TESLA,
	SENSOR_UNIT_DEGREE,
	SENSOR_UNIT_LUX,
	SENSOR_UNIT_CENTIMETER,
	SENSOR_UNIT_DEGREE_PER_SECOND,
	SENSOR_UNIT_MAX
} sensor_unit_e;

typedef struct _sensor_info sensor_info;

/**
 * @brief Extra value getter function
 * @param[in]   info    Sensor info
 * @param[in]   values  Values received from the sensor
 * @return Calculated value
 */
typedef float (*sensor_extra_value_get_cb)(const sensor_info *info,
		const float *values);

/**
 * @brief Extra value associated with the sensor
 * @details Allows to add value which is not received from the sensor,
 *          but instead calculated based on sensor values
 */
typedef struct _sensor_extra_value
{
	const char *name;   /**< Value name */
	const char *format; /**< Value printf() format for text representation */
	sensor_extra_value_get_cb value_get; /**< Value getter function */
} sensor_extra_value;

/**
 * @brief Sensor metadata
 */
struct _sensor_info
{
	sensor_h sensor;        /**< Sensor handle */
	sensor_type_e type;     /**< Sensor type, @see sensor_type_e */
	sensor_unit_e units;    /**< Values measurement units */

	const char *name;       /**< Sensor display name */
	const char **value_names;  /**< Value names array of value_count size */
	int value_count;        /**< Values count */

	float value_min;        /**< Minimal value */
	float value_max;        /**< Maximal value */
	float value_range;      /**< Values range */

	const char *units_str;  /**< Values measurement units string representation */
	const char *value_format;  /**< Values printf() format for text representation */
	int axes[3];            /**< Sensor axes directions relative to screen coordinate system */

	sensor_extra_value *extra_values;
	int extra_value_count;
};

#endif /* __SENSOR_INFO_H__ */
