/*
 * Copyright (c) 2014-2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __COLOR_UTILS_H__
#define __COLOR_UTILS_H__

/**
 * @brief Retrieve color component from color mask
 * @param[in]   color   Integer color representation (i.e. 0xRRGGBB)
 * @return Color component
 */
#define RED(color)      ((color >> 16) & 0xff)
#define GREEN(color)    ((color >> 8) & 0xff)
#define BLUE(color)     ((color) & 0xff)

/**
 * @brief Expand color integer representation as comma separated color
 *        components values
 */
#define RGB(color)    RED(color), GREEN(color), BLUE(color)

/**
 * @brief Expand color integer representation as comma separated color
 *        components float values (from 0.0 to 1.0)
 */
#define FRGB(color)   RED(color) / 255.0, GREEN(color) / 255.0, BLUE(color) / 255.0

#endif /* __COLOR_UTILS_H__ */
