/*
 * Copyright (c) 2014-2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __SENSOR_DATA_CHART_H__
#define __SENSOR_DATA_CHART_H__

#include <Evas.h>

/**
 * @brief Create sensor data representation chart
 * @param[in]   parent  Parent widget
 * @return Evas image object containing a chart on success, otherwise NULL
 */
Evas_Object *sensor_data_chart_create(Evas_Object *parent);

/**
 * @brief Update chart with new sensor data values
 * @param[in]   image       Chart image object
 * @param[in]   value_range Range of data values for proper chart scaling
 * @param[in]   values      Values to represent by a chart
 * @param[in]   colors      Color corresponding to the values
 * @param[in]   count       Number of values and corresponding colors
 */
void sensor_data_chart_update(Evas_Object *image, float value_range,
		const int *axes, const float *values, const int *colors, unsigned count);

#endif /* __SENSOR_DATA_CHART_H__ */
