/*
 * Copyright (c) 2014-2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __SENSOR_DATA_VIEW_H__
#define __SENSOR_DATA_VIEW_H__

#include <Evas.h>
#include "model/sensor-list.h"

/**
 * @brief Create sensor data view for specified sensor
 * @param[in]   navi            Parent naviframe
 * @param[in]   sensor_info     Sensor info for specific sensor
 * @return Main layout on success, otherwise NULL
 */
Evas_Object *sensor_data_view_create(Evas_Object *navi, const sensor_info *sensor_info);

#endif /* __SENSOR_DATA_VIEW_H__ */
