/*
 * Copyright (c) 2014-2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __SENSOR_VECTOR_CHART_H__
#define __SENSOR_VECTOR_CHART_H__

#include "view/sensor-data-chart.h"

/**
 * @brief Create chart for representing vector components
 * @details X and Y components are represented by arrow,
 *          Z component is represented by a circle of corresponding radius.
 * @remarks Use sensor_data_chart_update to set vector values and value range
 *          for created chart.
 * @remarks Arrows and circle are scaled according to current chart image size
 *          and value_range passed to sensor_data_chart_update.
 * @param[in]   parent  Parent widget
 * @return Evas image object containing a chart on success, otherwise NULL
 */
Evas_Object *sensor_vector_chart_create(Evas_Object *parent);

#endif /* __SENSOR_VECTOR_CHART_H__ */
