/*
 * Copyright (c) 2014-2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include "model/sensor-magnetic.h"

#include <math.h>

static float _magnetic_strength_get(const sensor_info *info,
		const float *values);

sensor_extra_value sensor_magnetic_strength_value = {
	.name = "Strength",
	.format = "%.2f",
	.value_get = _magnetic_strength_get
};

static float _magnetic_strength_get(const sensor_info *info,
		const float *values)
{
	float sum = 0.0;
	const float *value = values;
	const float *end = values + info->value_count;
	for (; value != end; ++value) {
		sum += *value * *value;
	}

	return sqrt(sum);
}
