/*
 * Copyright (c) 2014-2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __SENSOR_DATA_CHART_PRIVATE_H__
#define __SENSOR_DATA_CHART_PRIVATE_H__

#include <cairo.h>
#include "view/sensor-data-chart.h"

typedef struct _data_chart data_chart;
typedef void(*data_chart_draw_cb)(data_chart *chart, float value_range,
		const int *axes, const float *values, const int *colors, unsigned value_count);

struct _data_chart
{
	Evas_Object *image;
	int width;
	int height;

	cairo_t *cairo;
	cairo_surface_t *surface;
	data_chart_draw_cb draw_cb;
};

extern const char *chart_data_key;

#endif /* __SENSOR_DATA_CHART_PRIVATE_H__ */
