/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __main_H__
#define __main_H__

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <dlog.h>
#include <Ecore.h>

#define MAX_LENGTH_PATH 1024

typedef struct viewdata{
	Evas_Object *time;
	Evas_Object *msec;
	long lhour;
	long lmin;
	long lsec;
	long lmsec;
	double startTime;
	double elapsedTime;
	Ecore_Thread *thread;
	Eina_Bool stopped;
} viewdata_s;

typedef struct appdata{
	Evas_Object *win;
	Evas_Object *layout;
	Evas_Object *conform;
	Evas_Object *nf;
	Evas_Object *list;
	Evas_Object *btn_start;
	Evas_Object *btn_lap;
	Eina_Bool start;
	int count;

	viewdata_s *vd;
} appdata_s;

static inline const char *get_resource_path(const char * file_path);

#if !defined(PACKAGE)
#define PACKAGE "$(packageName)"
#endif

#define EDJPATH "edje"
#define LAYOUTEDJ get_resource_path(EDJPATH"/main_view.edj")

static inline const char *get_resource_path(const char *file_path)
{
    static char absolute_path[MAX_LENGTH_PATH] = {'\0'};

    static char *res_path_buff = NULL;
    if(res_path_buff == NULL)
    {
        res_path_buff = app_get_resource_path();
    }

    snprintf(absolute_path, MAX_LENGTH_PATH, "%s%s", res_path_buff, file_path);

    return absolute_path;
}

#endif /* __main_H__ */
