/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



#include <Ecore.h>
#include <tizen.h>

#include "log.h"
#include "stopwatch.h"
#include "main.h"
#include "thread.h"



static tizen_error_e _stopwatch_start_cb(void *data)
{
	appdata_s *ad = NULL;
	viewdata_s *vd = NULL;

	retv_if(!data, TIZEN_ERROR_INVALID_PARAMETER);

	_D("Pressed start button");

	ad = data;
	vd = ad->vd;

	elm_object_text_set(ad->btn_start, "STOP");
	elm_object_text_set(ad->btn_lap, "LAP");

	ad->start = EINA_TRUE;

	vd->lhour = 0;
	vd->lmin = 0;
	vd->lsec = 0;
	vd->lmsec = 0;

	/* run stopwatch */
	if (vd->stopped) {
		vd->startTime = ecore_time_get() - vd->elapsedTime;
	} else {
		vd->startTime = ecore_time_get();
	}

	/* tread run */
	vd->thread = ecore_thread_feedback_run(thread_job, thread_job_notify, thread_job_end, NULL, ad, EINA_FALSE);
	retv_if(!vd->thread, TIZEN_ERROR_INVALID_PARAMETER);

	return TIZEN_ERROR_NONE;
}



extern tizen_error_e stopwatch_stop_cb(void *data)
{
	appdata_s *ad = NULL;

	retv_if(!data, TIZEN_ERROR_INVALID_PARAMETER);

	_D("Pressed stop button");

	ad = data;

	elm_object_text_set(ad->btn_start, "START");
	elm_object_text_set(ad->btn_lap, "RESET");

	ad->vd->stopped = EINA_TRUE;

	ecore_thread_cancel(ad->vd->thread);
	ad->vd->thread = NULL;

	return TIZEN_ERROR_NONE;
}



static tizen_error_e _stopwatch_lap_cb(void *data)
{
	appdata_s *ad = NULL;
	viewdata_s *vd = NULL;
	Evas_Object *list = NULL;
	char buf[PATH_MAX] = "";

	retv_if(!data, TIZEN_ERROR_INVALID_PARAMETER);

	_D("Pressed lap button");

	ad = data;
	vd = ad->vd;
	list = ad->list;

	ad->count++;

	sprintf(buf, "   Lap %02d     |           %02ld:%02ld:%02ld.%02ld", ad->count, vd->lhour, vd->lmin, vd->lsec, vd->lmsec);
	elm_list_item_append(list, buf, NULL, NULL, NULL, NULL);
	elm_list_go(list);

	return TIZEN_ERROR_NONE;

}



static tizen_error_e _stopwatch_reset_cb(void *data)
{
	appdata_s *ad = NULL;
	viewdata_s *vd = NULL;

	retv_if(!data, TIZEN_ERROR_INVALID_PARAMETER);

	_D("Pressed reset button");

	ad = data;
	vd = ad->vd;

	elm_object_text_set(ad->btn_start, "START");
	elm_object_text_set(ad->btn_lap, "LAP");

	vd->lhour = 0;
	vd->lmin = 0;
	vd->lsec = 0;
	vd->lmsec = 0;

	ad->count = 0;
	ad->start = EINA_FALSE;
	ad->vd->stopped = EINA_FALSE;

	elm_list_clear(ad->list);

	elm_object_text_set(vd->time, "<font_size=105><color=#ffffff>00:00:00</color></font_size>");
	elm_object_text_set(vd->msec, "<font_size=50><color=#ffffff>.00</color></font_size>");

	return TIZEN_ERROR_NONE;
}



extern void stopwatch_button_clicked(void *data, Evas_Object *obj, void *event_info)
{
	const char *str = NULL;
	appdata_s *ad = NULL;

	ret_if(!data);
	ret_if(!obj);

	ad = data;
	str = elm_object_text_get(obj);

	tizen_error_e result = TIZEN_ERROR_UNKNOWN;

	if (str && !strcmp(str, "START")) {
		result = _stopwatch_start_cb(ad);
		retm_if(TIZEN_ERROR_NONE != result, "Failed to stopwatch start: %d", result);
	} else if (str && !strcmp(str, "STOP")) {
		result = stopwatch_stop_cb(ad);
		retm_if(TIZEN_ERROR_NONE != result, "Failed to stopwatch stop: %d", result);
	} else if (str && !strcmp(str, "LAP") && ad->start) {
		result = _stopwatch_lap_cb(ad);
		retm_if(TIZEN_ERROR_NONE != result, "Failed to stopwatch lap: %d", result);
	} else {
		result = _stopwatch_reset_cb(ad);
		retm_if(TIZEN_ERROR_NONE != result, "Failed to stopwatch reset: %d", result);
	}
}
/* End of file */
